% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcrWell.R, R/ddpcrPlate.R
\name{amplitudes}
\alias{amplitudes}
\alias{amplitudes,ddpcrWell-method}
\alias{amplitudes,ddpcrPlate-method}
\title{Retrieve droplet amplitudes.}
\usage{
amplitudes(theObject)

\S4method{amplitudes}{ddpcrWell}(theObject)

\S4method{amplitudes}{ddpcrPlate}(theObject)
}
\arguments{
\item{theObject}{A \code{\link{ddpcrWell}} or \code{\link{ddpcrPlate}}
object.}
}
\value{
If \code{theObject} is a \code{\link{ddpcrWell}} object, return
a data frame of droplet amplitudes with columns "Ch1.Amplitude" and
"Ch2.Amplitude". If \code{theObject} is a \code{\link{ddpcrPlate}} object,
return a list of data frames.
}
\description{
Retrieve the droplet amplitudes from an object.
}
\examples{
## Set a ddpcrWell object with no data.
aWell <- ddpcrWell(well=data.frame("Ch1.Amplitude"=double(),
                                   "Ch2.Amplitude"=double()))

## This can be checked to be empty.
amplitudes(aWell)

## Alternatively, load some data.
aWell <- ddpcrWell(well=KRASdata[["E03"]])

## We check again and see that it has been populated.
head(amplitudes(aWell))

# Get all of the KRASdata droplet amplitudes.
krasPlate <- ddpcrPlate(wells=KRASdata)
allDroplets <- amplitudes(krasPlate)
str(allDroplets)

}
\seealso{
\code{\link{wellClassification}} for the classification of the
droplets.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
