% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KRAScounts.R
\docType{data}
\name{KRAScounts}
\alias{KRAScounts}
\alias{KRAScountsWellCol}
\alias{KRAScountsQS}
\title{KRAS mutant and wild type droplet counts and Poisson estimates.}
\format{
A data frame where each row corresponds to a well/sample.

An object of class \code{data.frame} with 12 rows and 18 columns.

An object of class \code{data.frame} with 24 rows and 63 columns.
}
\usage{
data(KRAScounts)

data(KRAScountsWellCol)

data(KRAScountsQS)
}
\value{
A data frame.
}
\description{
A data frame of droplet counts using the standard 
\code{Cluster} classification from \code{\link{KRASdata}}. Each row 
corresponds to a well/sample and the columns \code{PP}, \code{PN}, \code{NP} 
and \code{NN} show how many droplets were in each cluster. The remaining 
rows were calculated from the counts figures except for the 
\code{InputAmount} column.

\code{KRAScountsWellCol} is the same data frame but has 
a \code{Well} column instead of named rows.

\code{KRAScountsQS} is a data frame imported from a CSV created 
by Bio-Rad's QuantaSoft.
}
\details{
The data frame was created by:
\preformatted{krasPlate <- ddpcrPlate(wells=KRASdata)
KRAScounts <- plateSummary(krasPlate, cMethod="Cluster")
onesVector <- c(1, 1, 1)
runAmount <- c(64 * onesVector, 16 * onesVector, 4 * onesVector, onesVector)
KRAScounts$InputAmount <- runAmount

KRAScountsWellCol <- KRAScounts
KRAScountsWellCol$Well <- rownames(KRAScounts)
KRAScountsWellCol <- KRAScountsWellCol[, c(18,1:17)]
rownames(KRAScountsWellCol) <- NULL
}
}
\author{
From the \code{\link{KRASdata}} dataset created by Mahmood Ayub, 
\email{mahmood.ayub@cruk.manchester.ac.uk}
}
\keyword{datasets}
