% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transomics2cytoscape.R
\name{createTransomicEdges}
\alias{createTransomicEdges}
\title{Create Trans-Omic edges between layers of the network.}
\usage{
createTransomicEdges(suid, transomicEdges)
}
\arguments{
\item{suid}{A SUID of Cytoscape network}

\item{transomicEdges}{Path of a TSV file with the 7 columns
(layer index of the source node,
the column name for which you want to find the attribute value of the
source node,
the attribute value of the source node should have,
layer index of a target node
name or KEGG object ID that the source node should have,
layer index of the target node,
the column name for which you want to find the attribute value of the
target node,
the attribute value of the target node should have,
name or KEGG object ID that the target node should have,
interaction type).}
}
\value{
A SUID of the 3D network.
}
\description{
Create Trans-Omic edges between layers of the network
}
\examples{
\dontrun{
layer1to2 <- system.file("extdata/usecase1", "k2e.tsv",
    package = "transomics2cytoscape")
suid <- createTransomicEdges(suid, layer1to2)
}
}
\author{
Kozo Nishida
}
