% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.R
\name{classify_spectrum}
\alias{classify_spectrum}
\title{Simple spectrum classifier based on empirical thresholds}
\usage{
classify_spectrum(
  adj_r_squared,
  degree,
  slope,
  consistency_score_n,
  n_significant,
  n_bins
)
}
\arguments{
\item{adj_r_squared}{adjusted \eqn{R^2} of polynomial model, returned by
\link{score_spectrum}}

\item{degree}{degree of polynomial, returned by \link{score_spectrum}}

\item{slope}{coefficient of the linear term of the polynomial model
(spectrum "direction"),
returned by \link{score_spectrum}}

\item{consistency_score_n}{number of performed permutations before
early stopping,
returned by \link{score_spectrum}}

\item{n_significant}{number of bins with statistically significant
enrichment}

\item{n_bins}{number of bins}
}
\value{
a three-dimensional binary vector with the following components:
\tabular{rl}{
  \code{coordinate 1} \tab \code{adj_r_squared >= 0.4}\cr
  \code{coordinate 2} \tab \code{consistency_score_n > 1000000}\cr
  \code{coordinate 3} \tab \code{n_significant >= floor(n_bins / 10)}
}
}
\description{
Spectra can be classified based on the aggregate spectrum classifier score.
If \code{sum(score) == 3} spectrum considered non-random, random otherwise.
}
\examples{
n_bins <- 40

# random spectrum
random_sp <- score_spectrum(runif(n = n_bins, min = -1, max = 1),
  max_model_degree = 1)
score <- classify_spectrum(
  get_adj_r_squared(random_sp), get_model_degree(random_sp),
  get_model_slope(random_sp), get_consistency_score_n(random_sp), 0, n_bins
)
sum(score)

# non-random linear spectrum with strong noise component
signal <- seq(-1, 0.99, 2 / 40)
noise <- rnorm(n = 40, mean = 0, sd = 0.5)
linear_sp <- score_spectrum(signal + noise, max_model_degree = 1,
  max_cs_permutations = 100000)
score <- classify_spectrum(
  get_adj_r_squared(linear_sp), get_model_degree(linear_sp),
  get_model_slope(linear_sp), get_consistency_score_n(linear_sp), 10, n_bins
)
sum(score)
\dontrun{
# non-random linear spectrum with weak noise component
signal <- seq(-1, 0.99, 2 / 40)
noise <- rnorm(n = 40, mean = 0, sd = 0.2)
linear_sp <- score_spectrum(signal + noise, max_model_degree = 1,
  max_cs_permutations = 100000)
score <- classify_spectrum(
  get_adj_r_squared(linear_sp), get_model_degree(linear_sp),
  get_model_slope(linear_sp), get_consistency_score_n(linear_sp), 10, n_bins
)
sum(score)
}

# non-random quadratic spectrum with strong noise component
signal <- seq(-1, 0.99, 2 / 40)^2 - 0.5
noise <- rnorm(n = 40, mean = 0, sd = 0.2)
quadratic_sp <- score_spectrum(signal + noise, max_model_degree = 2,
  max_cs_permutations = 100000)
score <- classify_spectrum(
  get_adj_r_squared(quadratic_sp), get_model_degree(quadratic_sp),
  get_model_slope(quadratic_sp),
  get_consistency_score_n(quadratic_sp), 10, n_bins
)
sum(score)
\dontrun{
# non-random quadratic spectrum with weak noise component
signal <- seq(-1, 0.99, 2 / 40)^2 - 0.5
noise <- rnorm(n = 40, mean = 0, sd = 0.1)
quadratic_sp <- score_spectrum(signal + noise, max_model_degree = 2)
score <- classify_spectrum(
  get_adj_r_squared(quadratic_sp), get_model_degree(quadratic_sp),
  get_model_slope(quadratic_sp),
  get_consistency_score_n(quadratic_sp), 10, n_bins
)
sum(score)
}
}
\seealso{
Other SPMA functions: 
\code{\link{run_kmer_spma}()},
\code{\link{run_matrix_spma}()},
\code{\link{score_spectrum}()},
\code{\link{subdivide_data}()}
}
\concept{SPMA functions}
