% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{check_kmers}
\alias{check_kmers}
\title{Check Validity of Set of \emph{k}-mers}
\usage{
check_kmers(kmers)
}
\arguments{
\item{kmers}{set of \emph{k}-mers}
}
\value{
\code{TRUE} if set of \emph{k}-mers is valid
}
\description{
Checks if the provided set of \emph{k}-mers is valid. A valid set
of \emph{k}-mers is
(1) non-empty, (2) contains either only hexamers or only heptamers,
 and (3) contains
only characters from the RNA alphabet (A, C, G, U)
}
\examples{
# valid set
check_kmers(c("ACGCUC", "AAACCC", "UUUACA"))

# invalid set (contains hexamers and heptamers)
check_kmers(c("ACGCUC", "AAACCC", "UUUACAA"))
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{create_kmer_origin_list}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
