% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_transcript_mc}
\alias{calculate_transcript_mc}
\title{Motif Enrichment calculation}
\usage{
calculate_transcript_mc(
  absoluteHits,
  totalSites,
  relHitsForeground,
  n,
  maxPermutations,
  minPermutations,
  e
)
}
\arguments{
\item{absoluteHits}{number of putative binding sites per sequence
(returned by \code{\link{score_transcripts}})}

\item{totalSites}{number of potential binding sites per sequence
(returned by \code{\link{score_transcripts}})}

\item{relHitsForeground}{relative number of hits in foreground set}

\item{n}{number of sequences in the foreground set}

\item{maxPermutations}{maximum number of foreground permutations
performed in
Monte Carlo test for enrichment score}

\item{minPermutations}{minimum number of foreground permutations
performed in
Monte Carlo test for enrichment score}

\item{e}{stop criterion for enrichment score Monte Carlo test:
aborting permutation process
after observing \code{e} random enrichment values with more extreme
values than the actual
enrichment value}
}
\value{
list with p-value and number of iterations of Monte Carlo sampling
for foreground enrichment
}
\description{
C++ implementation of Motif Enrichment calculation
}
\examples{
foreground_seqs <- c("CAGUCAAGACUCC", "AAUUGGUUGUGGGGCUUCCCUGUACAU",
                     "AGAU", "CCAGUAA", "UGUGGGG")
background_seqs <- c(foreground_seqs, "CAACAGCCUUAAUU", "CUUUGGGGAAU",
                     "UCAUUUUAUUAAA", "AUCAAAUUA", "GACACUUAAAGAUCCU",
                     "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
                     "AUAGAC", "AGUUC")
motif_db <- get_motif_by_id("M178_0.6")
fg <- score_transcripts(foreground_seqs, cache = FALSE,
  motifs = motif_db)
bg <- score_transcripts(background_seqs, cache = FALSE,
  motifs = motif_db)

mc_result <- calculate_transcript_mc(unlist(bg$absolute_hits),
 unlist(bg$total_sites),
 fg$df$absolute_hits / fg$df$total_sites,
 length(foreground_seqs), 1000, 500, 5)
}
