% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-RBPMotif.R
\docType{class}
\name{RBPMotif-class}
\alias{RBPMotif-class}
\alias{.RBPMotif}
\alias{get_id,RBPMotif-method}
\alias{get_id}
\alias{get_rbps,RBPMotif-method}
\alias{get_rbps}
\alias{get_motif_matrix,RBPMotif-method}
\alias{get_motif_matrix}
\alias{get_hexamers,RBPMotif-method}
\alias{get_hexamers}
\alias{get_heptamers,RBPMotif-method}
\alias{get_heptamers}
\alias{get_width,RBPMotif-method}
\alias{get_width}
\alias{get_iupac,RBPMotif-method}
\alias{get_iupac}
\alias{get_type,RBPMotif-method}
\alias{get_type}
\alias{get_species,RBPMotif-method}
\alias{get_species}
\alias{get_source,RBPMotif-method}
\alias{get_source}
\alias{show,RBPMotif-method}
\title{An S4 class to represent a RBPMotif}
\usage{
get_id(object)

\S4method{get_id}{RBPMotif}(object)

get_rbps(object)

\S4method{get_rbps}{RBPMotif}(object)

get_motif_matrix(object)

\S4method{get_motif_matrix}{RBPMotif}(object)

get_hexamers(object)

\S4method{get_hexamers}{RBPMotif}(object)

get_heptamers(object)

\S4method{get_heptamers}{RBPMotif}(object)

get_width(object)

\S4method{get_width}{RBPMotif}(object)

get_iupac(object)

\S4method{get_iupac}{RBPMotif}(object)

get_type(object)

\S4method{get_type}{RBPMotif}(object)

get_species(object)

\S4method{get_species}{RBPMotif}(object)

get_source(object)

\S4method{get_source}{RBPMotif}(object)

\S4method{show}{RBPMotif}(object)
}
\arguments{
\item{object}{RBPMotif object}
}
\value{
Object of type RBPMotif
}
\description{
An S4 class to represent a RBPMotif

Getter Method get_id

Getter Method get_rbps

Getter Method get_motif_matrix

Getter Method get_hexamers

Getter Method get_heptamers

Getter Method get_width

Getter Method get_iupac

Getter Method get_type

Getter Method get_species

Getter Method get_source
}
\section{Slots}{

\describe{
\item{\code{id}}{motif id (character vector of length 1)}

\item{\code{rbps}}{character vector of names of RNA-binding proteins associated
with this motif}

\item{\code{matrix}}{data frame with four columns (A, C, G, U) and 6 - 15 rows
(positions),
where cell (i, j) contains weight of nucleotide j on position i}

\item{\code{hexamers}}{character vector of hexamers associated with this motif}

\item{\code{heptamers}}{character vector of heptamers associated with this motif}

\item{\code{length}}{length of the motif (i.e., \code{nrow(matrix)})}

\item{\code{iupac}}{IUPAC code for motif matrix
(see \code{\link{generate_iupac_by_matrix}})}

\item{\code{type}}{type of motif (e.g., \code{'HITS-CLIP'}, \code{'EMSA'},
\code{'SELEX'}, etc.)}

\item{\code{species}}{species where motif was discovered (e.g.,
\code{'Homo sapiens'})}

\item{\code{src}}{source of motif (e.g., \code{'RBPDB v1.3.1'})}
}}

\examples{
kmers <- c("AAAAAAA", "CAAAAAA")
iupac <- generate_iupac_by_kmers(kmers,
  code = init_iupac_lookup_table())
hexamers <- generate_kmers_from_iupac(iupac, 6)
heptamers <- generate_kmers_from_iupac(iupac, 7)
new("RBPMotif", id = "custom_motif", rbps = "RBP1",
  matrix = NULL, hexamers = hexamers, heptamers = heptamers, length = 7L,
  iupac = iupac, type = "HITS-CLIP", species = "Homo sapiens", src = "user"
)
}
