% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{transcriptogramStep1}
\alias{transcriptogramStep1}
\alias{transcriptogramStep1,Transcriptogram-method}
\alias{transcriptogramStep1-method}
\title{Calculates the average of the expression values related to the same protein}
\usage{
transcriptogramStep1(object, expression, dictionary, nCores = 1L)

\S4method{transcriptogramStep1}{Transcriptogram}(object, expression,
  dictionary, nCores = 1L)
}
\arguments{
\item{object}{An object of class Transcriptogram.}

\item{expression}{A matrix, or data.frame, containing normalized expression
values from samples of microarrays or RNA-Seq (log2-counts-per-million).}

\item{dictionary}{A matrix, or data.frame, containing two columns, the first
column must contains the
ENSEMBL Peptide ID, and the second column must contains values that appear
as rownames in \code{expression},
in order to recognize the ENSEMBL Peptide ID of the other column.}

\item{nCores}{An integer number, referring to the number of processing cores
to be used; or a logical value, TRUE indicating that all processing cores
should be used, and FALSE indicating the use of just one processing core.
The default value of this argument is 1.}
}
\value{
This method creates a data.frame to feed the transcriptogramS1
slot of an object
of class Transcriptogram. Each row of the data.frame contains: an ENSEMBL
Peptide ID, its
respective position in the ordering and the mean of the expression values
of the identifiers
related to the same protein.
}
\description{
For each transcriptome sample, this method assigns to each protein the
average of the expression values of all the identifiers related to
it. It is necessary a
\code{dictionary} to map the identifiers to proteins.
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900)
\dontrun{
transcriptogram <- transcriptogramStep1(transcriptogram, GSE9988, GPL570)
}

}
\references{
da Silva, S. R. M., Perrone, G. C., Dinis, J. M., and de Almeida, R. M. C. (2014). Reproducibility enhancement and differential expression of non predefined functional gene sets in human genome. BMC Genomics.

de Almeida, R. M. C., Clendenon, S. G., Richards, W. G., Boedigheimer, M., Damore, M., Rossetti, S., Harris, P. C., Herbert, B. S., Xu, W. M., Wandinger-Ness, A., Ward, H. H., Glazier, J. A. and Bacallao, R. L. (2016). Transcriptome analysis reveals manifold mechanisms of cyst development in ADPKD. Human Genomics, 10(1), 1–24.

Ferrareze, P. A. G., Streit, R. S. A., Santos, P. R. dos, Santos, F. M. dos, de Almeida, R. M. C., Schrank, A., Kmetzsch, L., Vainstein, M. H. and Staats, C. C. (2017). Transcriptional Analysis Allows Genome Reannotation and Reveals that Cryptococcus gattii VGII Undergoes Nutrient Restriction during Infection. Microorganisms.

Morais, D. A. A., Almeida, R. M. C. and Dalmolin, R. J. S. (2019). Transcriptogramer: an R/Bioconductor package for transcriptional analysis based on protein–protein interaction. Bioinformatics.

Rybarczyk-Filho, J. L., Castro, M. A. A., Dalmolin, R. J. S., Moreira, J. C. F., Brunnet, L. G., and de Almeida, R. M. C. (2011). Towards a genome-wide transcriptogram: the Saccharomyces cerevisiae case. Nucleic Acids Research, 39(8), 3005-3016.

Xavier, L. A. da C., Bezerra, J. F., de Rezende, A. A., Oliveira, R. A. de C., Dalmolin, R. J. S., do Amaral, V. S. (2017). Analysis of genome instability biomarkers in children with non-syndromic orofacial clefts. Mutagenesis, 32(2), 313–321.
}
\seealso{
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer]{GSE9988},
\link[transcriptogramer]{GPL570},
\link[transcriptogramer]{Hs900},
\link[transcriptogramer]{association}
}
\author{
Diego Morais
}
