% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllConstructors.R
\name{transcriptogramPreprocess}
\alias{transcriptogramPreprocess}
\title{Creates an object of class Transcriptogram}
\usage{
transcriptogramPreprocess(association, ordering, radius = 0L)
}
\arguments{
\item{association}{A matrix, or data.frame, containing two columns of
ENSEMBL Peptide IDs (character); or the path for a file containing two
columns, no header, with rows composed by the ENSEMBL Peptide IDs of two
proteins that are connected.}

\item{ordering}{A character vector containing ordered ENSEMBL Peptide IDs;
a data.frame containing two columns, the first one with ENSEMBL Peptide IDs
(character), and the second containing its respective position (non-negative
integer); or the path for a file containing two columns, a row for the
headers, with rows composed respectively by a ENSEMBL Peptide ID and its
respective position.}

\item{radius}{An non-negative integer referring to the window radius required
for some methods.}
}
\value{
A preprocessed object of class Transcriptogram.
}
\description{
Constructor for the Transcriptogram object.
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900)

}
\seealso{
\link[transcriptogramer]{Transcriptogram-class},
\link[transcriptogramer]{association},
\link[transcriptogramer]{Hs900}
}
\author{
Diego Morais
}
