% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{differentiallyExpressed}
\alias{differentiallyExpressed}
\alias{differentiallyExpressed,Transcriptogram-method}
\alias{differentiallyExpressed-method}
\title{Identify which genes are differentially expressed}
\usage{
differentiallyExpressed(object, levels, pValue = 0.05,
  species = object@Protein2Symbol, adjustMethod = "BH",
  trend = FALSE, title = "Differential expression",
  boundaryConditions = TRUE, colors = NULL)

\S4method{differentiallyExpressed}{Transcriptogram}(object, levels,
  pValue = 0.05, species = object@Protein2Symbol,
  adjustMethod = "BH", trend = FALSE,
  title = "Differential expression", boundaryConditions = TRUE,
  colors = NULL)
}
\arguments{
\item{object}{An object of class Transcriptogram.}

\item{levels}{A logical vector that classify the columns, referring to
samples, of the transcriptogramS2 slot of the \code{object}. FALSE must
be used to indicate case samples, and TRUE to indicate control samples.}

\item{pValue}{A numeric value between 0 and 1 giving the required
family-wise error rate
or false discovery rate. The default value of this argument is 0.05.}

\item{species}{A character string that will be used,
ignoring case sensitivity,
to translate the ENSEMBL Peptide ID to Symbol (Gene Name); or a data.frame
containing two columns, the first one with ENSEMBL Peptide IDs (character),
which may, or not, to contain the taxonomy ID of the species as prefix,
and the second containing its respective Symbol (character). The default
value of this argument is the content of the object Protein2Symbol slot.}

\item{adjustMethod}{Character string specifying p-value adjustment method,
the possible values are
'none', 'BH', 'fdr' (equivalent to 'BH'), 'BY' and 'holm'. The default value
for this argument is 'BH'.}

\item{trend}{Logical value, set as TRUE to use the limma-trend approach for RNA-Seq.
The default value of this argument is FALSE.}

\item{title}{An overall title for the plot. The default value of this argument is "Differential expression"}

\item{boundaryConditions}{Logical value, defines whether the clusters limits will be extended using the
current value of the radius slot.
If TRUE, nearby clusters will be merged if its limits overlap.
The default value of this argument is TRUE.}

\item{colors}{Color vector used to distinguish the clusters. If NULL, the rainbow palette will be used
to generate the colors. The color vector must contain a color for each cluster.}
}
\value{
This method creates a data.frame to feed the DE slot of an object
of class Transcriptogram. This data.frame of differentially expressed
proteins
contains log2-fold-change, raw p-values, adjusted p-values, and an
integer number that indicates if the protein is downregulated (-1) or upregulated (1).
}
\description{
This method uses the \pkg{limma} package to identify which genes are
differentially expressed,
meeting the \code{pValue} requirement, for the contrast "case-control".
The \code{levels} lenght must be
equal to the number of samples present in the transcriptogramS2 slot of
the \code{object}, and its contents
is related to the order that the samples appear. FALSE must be used to
indicate case samples,
and TRUE to indicate control samples. If \code{species} is NULL, no
translation will be done, if \code{species} is a character,
the \pkg{biomaRt} package will be used to translate the ENSEMBL
Peptide ID to Symbol
(Gene Name), and if \code{species} is a data.frame, it will be used
instead.
If the translation fail for some protein, its ENSEMBL
Peptide ID will be present
into the Symbol column. This method also groups the differentially expressed proteins detected
in clusters, and plots a graphical representation of this clustering.
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900, 50)
\dontrun{
transcriptogram <- transcriptogramStep1(transcriptogram, GSE9988, GPL570)
transcriptogram <- transcriptogramStep2(transcriptogram)
levels <- c(rep(FALSE, 3), rep(TRUE, 3))
transcriptogram <- differentiallyExpressed(transcriptogram, levels, 0.01)

## translating ENSEMBL Peptide IDs to Symbols
transcriptogram <- differentiallyExpressed(transcriptogram, levels, 0.01,
"Homo sapiens")

## these calls also works
transcriptogram <- differentiallyExpressed(transcriptogram, levels, 0.01,
"H sapiens")

transcriptogram <- differentiallyExpressed(transcriptogram, levels, 0.01,
DEsymbols)
}

}
\seealso{
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer]{GSE9988},
\link[transcriptogramer]{GPL570},
\link[transcriptogramer]{Hs900},
\link[transcriptogramer]{association},
\link[transcriptogramer]{DEsymbols},
\link[transcriptogramer:transcriptogramStep1-method]{transcriptogramStep1},
\link[transcriptogramer:transcriptogramStep2-method]{transcriptogramStep2}
}
\author{
Diego Morais
}
