% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{clusterEnrichment}
\alias{clusterEnrichment}
\alias{clusterEnrichment,Transcriptogram-method}
\alias{clusterEnrichment-method}
\title{Term enrichment}
\usage{
clusterEnrichment(object, universe = NULL, species,
  ontology = "biological process", algorithm = "classic",
  statistic = "fisher", pValue = 0.05, adjustMethod = "BH",
  nCores = 1L, onlyGenesInDE = FALSE)

\S4method{clusterEnrichment}{Transcriptogram}(object, universe = NULL,
  species, ontology = "biological process", algorithm = "classic",
  statistic = "fisher", pValue = 0.05, adjustMethod = "BH",
  nCores = 1L, onlyGenesInDE = FALSE)
}
\arguments{
\item{object}{An object of class Transcriptogram.}

\item{universe}{A character vector containing ENSEMBL Peptide IDs, or NULL,
if the universe
is composed by all the proteins present in the ordering slot of
\code{object}.}

\item{species}{A character string specifying the species; or a data.frame
containing two columns, the first one with ENSEMBL Peptide IDs (character),
which may, or not, to contain the taxonomy ID of the species as prefix,
and the second containing its respective Gene Ontology term (character).}

\item{ontology}{A character string specifying the Gene Ontology domain,
ignoring case sensitivity,
the possible values are 'biological process', 'cellular component' and
'molecular function'.
The default value of this argument is 'biological process'.}

\item{algorithm}{Character string specifying which algorithm to use, the
possible values are
'classic', 'elim', 'weight', 'weight01', 'lea' and 'parentchild'.
The default value of this argument is 'classic'.}

\item{statistic}{Character string specifying which test to use, the possible
values are
'fisher', 'ks', 't', 'sum' and 'globaltest'.
The default value of this argument is 'fisher'.}

\item{pValue}{A numeric value between 0 and 1 giving the required
family-wise error rate or false discovery rate. The default value of this argument is 0.05.}

\item{adjustMethod}{Character string specifying p-value adjustment method,
the possible values are
'none', 'BH', 'fdr' (equivalent to 'BH'), 'BY', 'hochberg', 'hommel',
'bonferroni', and 'holm'.
The default value of this argument is 'BH'.}

\item{nCores}{An integer number, referring to the number of processing cores
to be used; or a logical value, TRUE indicating that all processing cores
should be used, and FALSE indicating the use of just one processing core.
The default value of this argument is 1.}

\item{onlyGenesInDE}{Logical value, set as TRUE to use only the genes
in the DE slot. Set as FALSE to use all the genes referring to the positions
in the clusters slot. The default value of this argument is FALSE.}
}
\value{
This method creates a data.frame, containing the most significant
terms of each cluster, to feed the Terms slot of an object of class
Transcriptogram.
}
\description{
If \code{species} is a character, this method uses the \pkg{biomaRt} package
to build a Protein2GO list, if \code{species} is a data.frame, it will be used
instead.
The Protein2GO list will be used with the
\pkg{topGO} package to detect the most significant terms of each cluster
present in the DE slot of the \code{object}.
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900, 50)
\dontrun{
transcriptogram <- transcriptogramStep1(transcriptogram, GSE9988, GPL570)
transcriptogram <- transcriptogramStep2(transcriptogram)
levels <- c(rep(FALSE, 3), rep(TRUE, 3))
transcriptogram <- differentiallyExpressed(transcriptogram, levels, 0.01)
transcriptogram <- clusterEnrichment(transcriptogram, species = "Homo sapiens",
pValue = 0.005)

## this call also works
transcriptogram <- clusterEnrichment(transcriptogram, species = HsBPTerms,
pValue = 0.005)
}

}
\seealso{
\link[transcriptogramer:differentiallyExpressed-method]{differentiallyExpressed},
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer]{GSE9988},
\link[transcriptogramer]{GPL570},
\link[transcriptogramer]{Hs900},
\link[transcriptogramer]{HsBPTerms},
\link[transcriptogramer]{association},
\link[transcriptogramer:transcriptogramStep1-method]{transcriptogramStep1},
\link[transcriptogramer:transcriptogramStep2-method]{transcriptogramStep2}
}
\author{
Diego Morais
}
