% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Transcriptogram-class}
\alias{Transcriptogram-class}
\title{Class Transcriptogram}
\description{
This S4 class includes methods to use expression values with ordered
proteins.
}
\section{Slots}{

\describe{
\item{\code{association}}{A data.frame containing two columns, with rows containing
ENSEMBL Peptide IDs that are connected.}

\item{\code{ordering}}{A data.frame containing two columns, the first one with
ENSEMBL Peptide IDs, and the second containing its respective position.}

\item{\code{transcriptogramS1}}{A data.frame produced as the result of averaging
over all identifiers related to the same protein.}

\item{\code{transcriptogramS2}}{A data.frame produced as the result of averaging
over the window.}

\item{\code{radius}}{An non-negative integer referring to the window radius.}

\item{\code{status}}{An integer used internally to check the status of the object.}

\item{\code{DE}}{A data.frame of differentially expressed proteins.}

\item{\code{clusters}}{A list indicating the first and the last position belonging to
each cluster.}

\item{\code{pbc}}{Logical value used internally to indicate the overlapping of the
first and the last cluster.}

\item{\code{Protein2Symbol}}{A data.frame containing two columns, the first one with
ENSEMBL Peptide IDs, and the second containing its respective Symbol.}

\item{\code{Protein2GO}}{A data.frame containing two columns, the first one with
ENSEMBL Peptide IDs, and the second containing its respective Gene Ontology accession.}

\item{\code{Terms}}{A data.frame containing the enriched Gene Ontology terms.}

\item{\code{genesInTerm}}{A list of GO terms and its respective ENSEMBL Peptide IDs, feeded by
the clusterEnrichment() method.}
}}

\seealso{
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer:DE-method]{DE},
\link[transcriptogramer:radius-method]{radius},
\link[transcriptogramer:orderingProperties-method]{orderingProperties},
\link[transcriptogramer:connectivityProperties-method]{connectivityProperties},
\link[transcriptogramer:transcriptogramStep1-method]{transcriptogramStep1},
\link[transcriptogramer:transcriptogramStep2-method]{transcriptogramStep2},
\link[transcriptogramer:differentiallyExpressed-method]{differentiallyExpressed},
\link[transcriptogramer:clusterVisualization-method]{clusterVisualization},
\link[transcriptogramer:clusterEnrichment-method]{clusterEnrichment},
\link[transcriptogramer:enrichmentPlot-method]{enrichmentPlot}
}
\author{
Diego Morais
}
