% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChipDataSet-generics.R, R/ChipDataSet-methods.R
\docType{methods}
\name{plotROC}
\alias{plotROC}
\alias{plotROC,ChipDataSet-method}
\title{plotROC}
\usage{
plotROC(object, ...)

\S4method{plotROC}{ChipDataSet}(object, ...)
}
\arguments{
\item{object}{A \code{\link{ChipDataSet}} object.}

\item{...}{Further arguments passed to plot.}
}
\value{
ROC plot.
}
\description{
Visualize the performance of the classification model fit (prediction of the
gene associated peaks).
}
\details{
The \code{plotROC} is a simple wrapper for the \code{plot} function
    implemented in \code{\link{pROC}} package.

    The \href{https://en.wikipedia.org/wiki/Receiver_operating_characteristic}{ROC}
    curve is created by plotting the true positive rate (sensitivity) against
    the false positive rate (1 - specificity) at various threshold settings.
    The closer the curve follows the left-hand border and then the top border
    of the ROC space, the more accurate the test. The area under the curve
    (AUC) is a measure of accuracy.
}
\examples{
### Load ChipDataSet object
data(cds)

### Classify peaks on gene associated and background
predictTssOverlap(object = cds, feature = "pileup", p = 0.75)

### Visualize the performance of the model fit
plotROC(object = cds, col = "red3", grid = TRUE, auc.polygon = TRUE)

}
\author{
Armen R. Karapetyan
}
\seealso{
\code{\link{predictTssOverlap}}
}

