% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_GInteractions.R
\name{reduce,GInteractions-method}
\alias{reduce,GInteractions-method}
\alias{reduce,GInteractions}
\title{Reduce method for 'GInteractions'}
\usage{
\S4method{reduce}{GInteractions}(x, min.gapwidth = 1L, ignore.strand = TRUE, ...)
}
\arguments{
\item{x}{GInteractions object.}

\item{min.gapwidth}{Ranges separated by a gap of at least min.gapwidth
positions are not merged.}

\item{ignore.strand}{TRUE or FALSE. Whether the strand of the input ranges
should be ignored or not.}

\item{...}{Not used.}
}
\description{
Reduce returns an object of the same type as x containing reduced ranges for
each distinct (seqname, strand) pairing.
}
\examples{
\dontrun{
library(InteractionSet) 
gi <- readRDS(system.file("extdata", "gi.rds", package="trackViewer"))
reduce(head(gi, n=20))
}

}
