% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGInteractions.R
\name{importGInteractions}
\alias{importGInteractions}
\title{Reading data from a ginteractions, hic, cool, or validPairs file}
\usage{
importGInteractions(
  file,
  format = c("ginteractions", "hic", "cool", "validPairs"),
  ranges = GRanges(),
  ignore.strand = TRUE,
  out = c("track", "GInteractions"),
  resolution = 1e+05,
  unit = c("BP", "FRAG"),
  normalization = c("NONE", "VC", "VC_SQRT", "KR", "SCALE", "GW_KR", "GW_SCALE", "GW_VC",
    "INTER_KR", "INTER_SCALE", "INTER_VC", "balanced"),
  matrixType = c("observed", "oe", "expected"),
  ...
)
}
\arguments{
\item{file}{The path to the file to read.}

\item{format}{The format of import file. Could be ginteractions, hic, cool or validPairs}

\item{ranges}{An object of \code{\link[GenomicRanges:GRanges-class]{GRanges}} to indicate
the range to be imported. For .hic file, if the length of ranges is 2, 
the first range will be used as anchor 1 and the second range will be used
as anchor 2.}

\item{ignore.strand}{ignore the strand or not when do filter. default TRUE}

\item{out}{output format. Default is track. Possible values: track, GInteractions.}

\item{resolution}{Resolutions for the interaction data.}

\item{unit}{BP (base pair) or FRAG (fragment) (.hic file only).}

\item{normalization}{Type of normalization, NONE, VC, VC_SORT or KR for .hic and
NONE, balanced for .cool.}

\item{matrixType}{Type of matrix for .hic file. Available choices are "observed", "oe", and "expected".
default is "observed".}

\item{...}{NOT used.}
}
\value{
a \code{\link{track}} object
}
\description{
Read a \code{\link{track}} object from a ginteractions, hic, mcool, or validPairs file
}
\examples{
#import a ginteractions file
#gi <- system.file("extdata", "test.ginteractions.tsv", package="trackViewer",
#                       mustWork=TRUE)
#dat <- importGInteractions(file=gi, format="ginteractions",
#                   ranges=GRanges("chr7", IRanges(127471197, 127474697)))

##import a hic file
if(.Platform$OS.type!="windows"){
hic <- system.file("extdata", "test_chr22.hic", package = "trackViewer",
                       mustWork=TRUE)
dat <- importGInteractions(file=hic, format="hic", 
                           ranges=GRanges("22", IRanges(1500000, 100000000)))
}

##import a cool file
cool <- system.file("extdata", "test.mcool", package = "trackViewer",
                     mustWork=TRUE)
dat <- importGInteractions(file=cool, format="cool",
                           resolution = 2,
                           ranges=GRanges("chr1", IRanges(10, 28)))

##import a validPairs file
#validPairs <- system.file("extdata", "test.validPairs", package = "trackViewer",
#                       mustWork=TRUE)
#dat <- importGInteractions(file=validPairs, format="validPairs")

}
\seealso{
See Also as \code{\link{listResolutions}}, \code{\link{listChromosomes}}, 
\code{\link[strawr]{readHicNormTypes}}
}
