% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGeneIDsFromTxDb.R
\name{getGeneIDsFromTxDb}
\alias{getGeneIDsFromTxDb}
\title{get gene ids by genomic location}
\usage{
getGeneIDsFromTxDb(gr, txdb)
}
\arguments{
\item{gr}{GRanges object.}

\item{txdb}{An object of \code{\link[GenomicFeatures:TxDb-class]{TxDb}}.}
}
\value{
A character vector of gene ids
}
\description{
retrieve gene ids from txdb object by genomic location.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
gr <- parse2GRanges("chr11:122,830,799-123,116,707")
ids <- getGeneIDsFromTxDb(gr, TxDb.Hsapiens.UCSC.hg19.knownGene)
}
