% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-TopDownSet.R
\docType{class}
\name{TopDownSet-class}
\alias{TopDownSet-class}
\alias{aggregate,TopDownSet-method}
\alias{combine,TopDownSet,TopDownSet-method}
\alias{filterCv,TopDownSet-method}
\alias{filterCv}
\alias{filterInjectionTime,TopDownSet-method}
\alias{filterInjectionTime}
\alias{filterIntensity,TopDownSet-method}
\alias{filterIntensity}
\alias{filterNonReplicatedFragments,TopDownSet-method}
\alias{filterNonReplicatedFragments}
\alias{normalize,TopDownSet-method}
\alias{plot,TopDownSet,missing-method}
\alias{show,TopDownSet-method}
\alias{summary,TopDownSet-method}
\alias{coerce,TopDownSet,MSnSet-method}
\alias{coerce,TopDownSet,NCBSet-method}
\title{The TopDownSet class}
\usage{
\S4method{aggregate}{TopDownSet}(x, by = x$Sample, ...)

\S4method{combine}{TopDownSet,TopDownSet}(x, y)

\S4method{filterCv}{TopDownSet}(object, threshold, by = object$Sample, ...)

\S4method{filterInjectionTime}{TopDownSet}(
  object,
  maxDeviation = log2(3),
  keepTopN = 2,
  by = object$Sample,
  ...
)

\S4method{filterIntensity}{TopDownSet}(object, threshold, relative = TRUE, ...)

\S4method{filterNonReplicatedFragments}{TopDownSet}(object, minN = 2, by = object$Sample, ...)

\S4method{normalize}{TopDownSet}(object, method = "TIC", ...)

\S4method{plot}{TopDownSet,missing}(x, y, ..., verbose = interactive())

\S4method{show}{TopDownSet}(object)

\S4method{summary}{TopDownSet}(object, what = c("conditions", "fragments"), ...)
}
\arguments{
\item{x, object}{\code{TopDownSet}}

\item{by}{\code{list},
grouping variable, in general it refers to technical}

\item{y}{\code{missing}, not used.}

\item{threshold}{\code{double}, threshold variable.}

\item{maxDeviation}{\code{double},
maximal allowed deviation in the \code{log2}
injection time in ms in comparison to the median ion injection time.}

\item{keepTopN}{\code{integer}, how many technical replicates should be kept?}

\item{relative}{\code{logical},
if relative is \code{TRUE} all fragments with
intensity below \code{threshold * max(intensity)}
per fragment are removed,
otherwise all fragments below \code{threshold} are removed.}

\item{minN}{\code{numeric},
if less than \code{minN} of a fragment are found across
technical replicates it is removed.}

\item{method}{\code{character},
normalisation method, currently just \code{"TIC"}
for \emph{T}otal \emph{I}on \emph{C}urrent
normalisation of the scans/conditions (column-wise normalisation)
is supported.}

\item{verbose}{\code{logical}, verbose output?}

\item{what}{\code{character},
specifies whether \code{"conditions"} (columns; default)
or \code{"fragments"} (rows) should be summarized.}

\item{\ldots}{arguments passed to internal/other methods.
replicates (that's why the default is the
\code{"Sample"} column in \code{colData}).}
}
\value{
An \linkS4class{TopDownSet} object.
}
\description{
The TopDownSet class is a container for a whole top-down proteomics
experiment.
}
\details{
See \code{vignette("analysis", package="topdownr")}
for a detailed example how to work with
\code{TopDownSet} objects.
}
\section{Methods (by generic)}{
\itemize{
\item \code{aggregate(TopDownSet)}: Aggregate conditions/runs.

Aggregates conditions/runs (columns) in an
\linkS4class{TopDownSet} object
\code{by} a
user-given value (default is the
\code{"Sample"} column of \code{colData}
which has the same value for technical replicates).
It combines intensity values and numeric metadata of the grouped
conditions/runs (columns) by \code{mean} and returns a reduced
\linkS4class{TopDownSet} object.

\item \code{combine(x = TopDownSet, y = TopDownSet)}: Combine \code{TopDownSet} objects.

\code{combine} allows to combine two or more \code{TopDownSet} objects.
Please note that it uses the default
\code{sampleColumns} to define technical replicates (see \code{\link[=readTopDownFiles]{readTopDownFiles()}}).and
the default \code{by} argument to group ion injection times for the calculation of
the median time (see \code{\link[=updateMedianInjectionTime]{updateMedianInjectionTime()}}). Both could be modified
after \code{combine} by calling \code{\link[=updateConditionNames]{updateConditionNames()}} (with modified
\code{sampleColumns} argument) and \code{\link[=updateMedianInjectionTime]{updateMedianInjectionTime()}} (with modified
\code{by} argument).

\item \code{filterCv(TopDownSet)}: Filter by CV.

Filtering is done by coefficient of variation across technical replicates
(defined by the \code{by} argument).
All fragments below a given \code{threshold}
are removed. The \code{threshold} is the maximal allowed CV in percent
(\code{sd/mean * 100 < threshold}).

\item \code{filterInjectionTime(TopDownSet)}: Filter by ion injection time.

Filtering is done by maximal allowed deviation and just the technical
\code{keepTopN} replicates with the lowest deviation from the median ion
injection time are kept.

\item \code{filterIntensity(TopDownSet)}: Filter by intensity.

Filtering is done by removing all fragments that are below a given
(absolute/relative) intensity \code{threshold}.

\item \code{filterNonReplicatedFragments(TopDownSet)}: Filter by non-replicated fragments.

Filtering is done by removing all fragments that don't replicate across
technical replicates.

\item \code{normalize(TopDownSet)}: Normalise.

Applies \emph{T}otal \emph{I}on \emph{C}urrent normalisation to a
\linkS4class{TopDownSet} object.
The normalisation ist done per scans/conditions (column-wise normalisation).

\item \code{plot(x = TopDownSet, y = missing)}: Plotting.

Plots an \linkS4class{TopDownSet} object. The function returns a \code{list}
of \code{ggplot} objects (one item per condtion).
Use \code{pdf} or another non-interactive device to plot the list of \code{ggplot}
objects (see example section).

\item \code{summary(TopDownSet)}: Summary statistics.

Returns a \code{matrix}
with some statistics: number of fragments,
total/min/first quartile/median/mean/third quartile/maximum of
intensity values.

}}
\section{Slots}{

\describe{
\item{\code{rowViews}}{\linkS4class{FragmentViews},
information about fragments (name, type, sequence, mass, charge), see
\linkS4class{FragmentViews} for details.}

\item{\code{colData}}{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame},
information about the MS2 experiments and the fragmentation conditions.}

\item{\code{assay}}{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix},
intensity values of the fragments. The
rows correspond to the fragments and the columns to the condition/run. It
just stores values that are different from zero.}

\item{\code{files}}{\code{character}, files that were imported.}

\item{\code{tolerance}}{\code{double},
tolerance in \emph{ppm} that were used for matching the
experimental mz values to the theoretical fragments.}

\item{\code{redundantMatching}}{\code{character}, matching strategies for redundant
ion/fragment matches. See \code{redundantIonMatch} and
\code{redundantFragmentMatch} in \code{\link[=readTopDownFiles]{readTopDownFiles()}} for details.}

\item{\code{processing}}{\code{character}, log messages.}
}}

\section{Coercion}{


`as(object, "MSnSet"): Coerce an \linkS4class{TopDownSet} object into an
\link[MSnbase:MSnSet-class]{MSnbase::MSnSet} object.



`as(object, "NCBSet"): Coerce an \linkS4class{TopDownSet} object into an
\linkS4class{NCBSet} object.
}

\examples{
## Example data
data(tds, package="topdownr")

tds

head(summary(tds))

# Accessing slots
rowViews(tds)
colData(tds)
head(assayData(tds))

# Accessing colData
tds$Mz
tds$FilterString

# Subsetting

# First 100 fragments
tds[1:100]

# All c fragments
tds["c"]

# Just c 152
tds["c152"]

# Condition 1 to 10
tds[, 1:10]

# Filtering
# Filter all intensities that don't have at least 10 \% of the highest
# intensity per fragment.
tds <- filterIntensity(tds, threshold=0.1)

# Filter all conditions with a CV above 30 \% (across technical replicates)
tds <- filterCv(tds, threshold=30)

# Filter all conditions with a large deviation in injection time
tds <- filterInjectionTime(tds, maxDeviation=log2(3), keepTopN=2)

# Filter all conditions where fragments don't replicate
tds <- filterNonReplicatedFragments(tds)

# Normalise by TIC
tds <- normalize(tds)

# Aggregate technical replicates
tds <- aggregate(tds)

head(summary(tds))

# Coercion
as(tds, "NCBSet")

if (require("MSnbase")) {
    as(tds, "MSnSet")
}
\dontrun{
# plot a single condition
# pseudo-code (replace topdownset with your object)
plot(topdownset[,1])

# plot the whole object
pdf("topdown-spectra.pdf", paper="a4r", width=12)
# pseudo-code (replace topdownset with your object)
plot(topdownset)
dev.off()
}
}
\seealso{
\itemize{
\item \linkS4class{FragmentViews}
for the row view interface.
\item \link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}
for technical details about the intensity storage.
\item \code{?vignette("analysis", package="topdownr")}
for a full documented example of an analysis using \code{topdownr}.
}
}
\author{
Sebastian Gibb \email{mail@sebastiangibb.de}
}
