% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_function.R
\name{animate2d}
\alias{animate2d}
\title{Animate 2D expressions along one axis and generate GIF file.}
\usage{
animate2d(
  tomoObj,
  geneID,
  along = "x",
  main = geneID,
  xlab = "x",
  ylab = "y",
  file = str_c(geneID, "_", along, ".gif"),
  zlim = NA,
  interval = 0.1,
  aspectX = 1,
  aspectY = 1
)
}
\arguments{
\item{tomoObj}{tomoSeq object}

\item{geneID}{single gene ID (string)}

\item{along}{Parameter specifying along which axis the cross section should
be plotted.}

\item{main}{A string used for the title of the plot. Default is \code{geneID}.}

\item{xlab}{Label of x axis. Default is \code{xaxis}.}

\item{ylab}{Label of y axis. Default is \code{yaxis}.}

\item{file}{Path of GIF file.}

\item{zlim}{Limit of value of heatmap. If target="mask", it is ignored.}

\item{interval}{interval of GIF animation.}

\item{aspectX}{Width of figure. If you don't specify the value of
this parameter, It is calculated based on the number of sections
Corresponding to the horizontal axis}

\item{aspectY}{Height of figure. If you don't specify the value of
this parameter, It is calculated based on the number of sections
Corresponding to the vertical axis}
}
\value{
It generate GIF file.
}
\description{
Animate 2D expressions along one axis and generate GIF file.
}
\examples{
if(interactive()) {
    data(tomoObj)
    animate2d(tomoObj, "gene2", target = "expression", file = "example.gif")
}
}
