% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{tomoSummarizedExperiment}
\alias{tomoSummarizedExperiment}
\title{Create an object from SummarizedExperiment}
\usage{
tomoSummarizedExperiment(
  se,
  min.section = 3,
  normalize = TRUE,
  normalize.method = "median",
  scale = TRUE
)
}
\arguments{
\item{se}{A SummarizedExperiment object, it must contain at least one of 'count' assay and 'normalized' assay.}

\item{min.section}{Integer. Genes expressed in less than \code{min.section} sections will be filtered out.}

\item{normalize}{Logical, whether to perform normalization when creating the object. Default is TRUE.}

\item{normalize.method}{Character, must be one of \code{"median"}, or \code{"cpm"}.}

\item{scale}{Logical, whether to perform scaling when creating the object. Default is TRUE.}
}
\value{
A \code{SummarizedExperiment} object
}
\description{
\code{tomoSummarizedExperiment} creates an object from a SummarizedExperiment object.
}
\examples{
data(zh.data)
se <- SummarizedExperiment::SummarizedExperiment(assays=list(count=zh.data))
zh <- tomoSummarizedExperiment(se)
}
\seealso{
\code{\link{createTomo}} for the generic function.
}
