% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{findPeakGene}
\alias{findPeakGene}
\title{Find peak genes}
\usage{
findPeakGene(
  object,
  threshold = 1,
  length = 4,
  matrix = "scaled",
  nperm = 1e+05,
  method = "BH"
)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{threshold}{Integer, only scaled read counts bigger than \code{threshold} are recognized as part of the peak.}

\item{length}{Integer, scaled read counts bigger than \code{threshold} in minimum \code{length} of consecutive sections are recognized as a peak.}

\item{matrix}{Character, must be one of \code{"count"}, \code{"normalized"}, or \code{"scaled"}.}

\item{nperm}{Integer, number of random permutations to calculate p values. Set it to 0 if you are not interested in p values.}

\item{method}{Character, the method to adjust p values for multiple comparisons, must be one of \code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}
}
\value{
A data.frame with peak genes as rows. It has following columns:
\itemize{
\item{\code{gene}} : Character, peak gene names.
\item{\code{start}} : Numeric, the start index of peak.
\item{\code{end}} : Numeric, the end index of peak.
\item{\code{center}} : Numeric, the middle index of peak. If the length of the peak is even, \code{center} is defined as the left-middle index.
\item{\code{p}} : Numeric, p values.
\item{\code{p.adj}} : Numeric, adjusted p values.
}
}
\description{
Find peak genes (spatially upregulated genes) in a \code{SummarizedExperiment} object.
}
\details{
Peak genes are selected based on scaled read counts. As scaled read counts are Z scores, suggested \code{threshold} are \eqn{[1,3]}.
Smaller \code{threshold} and \code{length} makes the function detect more peak genes, and vice versa.
P values are calculated by approximate permutation tests. For a given \code{threshold} and \code{length}, the scaled read counts of each gene is randomly permutated for \code{nperm} times. The p value is defined as the ratio of permutations containing peaks.
In order to speed up permutation process, genes whose expression exceeds threshold in same number of sections have same p values.
To be specific, only one of these genes will be used to calculate a p value by permutation, and other genes are assigned this p value.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)
peak_genes <- findPeakGene(zh)
head(peak_genes)

# Increase threshold so that less peak genes will be found.
peak_genes <- findPeakGene(zh, threshold=1.5)

# Increase peak length so that less peak genes will be found.
peak_genes <- findPeakGene(zh, length=5)

# Set nperm to 0 so that p values will not be calculated. This will save running time.
peak_genes <- findPeakGene(zh, nperm=0)
}
