% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescape.R
\name{timescape}
\alias{timescape}
\title{TimeScape}
\usage{
timescape(clonal_prev, tree_edges, mutations = "NA", clone_colours = "NA",
  xaxis_title = "Time Point", yaxis_title = "Clonal Prevalence",
  phylogeny_title = "Clonal Phylogeny", alpha = 50,
  genotype_position = "stack", perturbations = "NA", sort = FALSE,
  show_warnings = TRUE, width = 900, height = NULL)
}
\arguments{
\item{clonal_prev}{\code{data.frame} Clonal prevalence. 
    Required columns are:
    \describe{

      \item{timepoint:}{\code{character()} time point. Time
         points will be alphanumerically sorted in the view.}

      \item{clone_id:}{\code{character()} clone id.}

      \item{clonal_prev:}{\code{numeric()} clonal prevalence.}

    }}

\item{tree_edges}{\code{data.frame} Tree edges of a rooted tree. 
    Required columns are:
    \describe{

      \item{source:}{\code{character()} source node id.}

      \item{target:}{\code{character()} target node id.}

    }}

\item{mutations}{\code{data.frame} (Optional)  Mutations 
    occurring at each clone. Required columns are:
    \describe{

      \item{chrom:}{\code{character()} chromosome number.}

      \item{coord:}{\code{numeric()} coordinate of mutation 
         on chromosome.}

      \item{clone_id:}{\code{character()} clone id.}

      \item{timepoint:}{\code{character()} time point.}

      \item{VAF:}{\code{numeric()} variant allele frequency 
         of the mutation in the corresponding timepoint.}

    }
    Any additional field will be shown in the mutation table.}

\item{clone_colours}{\code{data.frame} Clone ids and their 
    corresponding colours. Required columns are:
    \describe{

      \item{clone_id:}{\code{character()} clone id.}

      \item{colour:}{\code{character()} the corresponding Hex 
         colour for each clone id.}

    }}

\item{xaxis_title}{\code{character()} (Optional) x-axis title. 
Default is "Time Point".}

\item{yaxis_title}{\code{character()} (Optional) y-axis title. 
Default is "Clonal Prevalence".}

\item{phylogeny_title}{\code{character()} (Optional) Legend 
phylogeny title. Default is "Clonal Phylogeny".}

\item{alpha}{\code{numeric()} (Optional) Alpha value for clonal 
sweeps, range [0, 100].}

\item{genotype_position}{\code{character()} (Optional) How to 
    position the genotypes from ["centre", "stack", "space"].
  \enumerate{

      \item centre: genotypes are centred with
         respect to their ancestors.

      \item stack: genotypes are stacked such  
         that nogenotype is split at any time point.

      \item space: genotypes are stacked but  
         with a bit of spacing at the bottom.

    }}

\item{perturbations}{\code{data.frame} (Optional) Any
    perturbations that occurred between two time points. 
    Required columns are:
    \describe{

      \item{pert_name:}{\code{character()} the perturbation name.}

      \item{prev_tp:}{\code{character()} the time point (as labelled 
         in clonal prevalence data) BEFORE perturbation.}

    }}

\item{sort}{\code{logical()} (Optional) Whether (TRUE) or not (FALSE) 
to vertically sort the genotypes by their emergence values 
(descending). Default is FALSE. Note that genotype sorting will 
always retain the phylogenetic hierarchy, and this parameter will 
only affect the ordering of siblings.}

\item{show_warnings}{\code{logical()} (Optional) Whether or not to show 
any warnings. Default is TRUE.}

\item{width}{\code{numeric()} (Optional) Width of the plot. Minimum 
width is 450.}

\item{height}{\code{numeric()} (Optional) Height of the plot. Minimum
height with and without mutations is 500 and 260, respectively.}
}
\value{
None
}
\description{
\code{timescape} is a tool for visualizing temporal clonal evolution data.
}
\details{
Interactive components:
  \enumerate{

\item Mouseover any clone to view its (i) clone ID and (ii) clonal
    prevalence at each time point.

\item Click the view switch button to switch from the traditional
    timescape view to the clonal trajectory view, where each clone
    changes prevalence on its own track.

\item Click the download buttons to download a PNG or SVG of the
    view.

}
}
\examples{

# EXAMPLE 1 - Acute myeloid leukemia patient, Ding et al., 2012

# genotype tree edges
tree_edges <- read.csv(system.file("extdata", "AML_tree_edges.csv", 
    package = "timescape"))

# clonal prevalences
clonal_prev <- read.csv(system.file("extdata", "AML_clonal_prev.csv",
    package = "timescape"))

# targeted mutations
mutations <- read.csv(system.file("extdata", "AML_mutations.csv", 
    package = "timescape"))

# perturbations
perturbations <- data.frame( pert_name = c("Chemotherapy"), 
                             prev_tp = c("Diagnosis"))

# run timescape
timescape(clonal_prev = clonal_prev, tree_edges = tree_edges, 
    perturbations = perturbations, mutations = mutations)

# EXAMPLE 2 - Patient 7, McPherson and Roth et al., 2016

# genotype tree edges
tree_edges <- read.csv(system.file("extdata", "px7_tree_edges.csv", 
    package = "timescape"))

# clonal prevalences
clonal_prev <- read.csv(system.file("extdata", "px7_clonal_prev.csv", 
    package = "timescape"))

# clone colours
clone_colours <- data.frame(clone_id = c("A","B","C","D","E"), 
                            colour = c("d0ced0", "2CD0AB", "FFD94B", 
                                     "FD8EE5", "F8766D"))

# run timescape
timescape(clonal_prev = clonal_prev, tree_edges = tree_edges, 
    clone_colours = clone_colours, height=260, alpha=15)
}
