% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneCluster.spls.R
\name{tuneCluster.spls}
\alias{tuneCluster.spls}
\title{Feature Selection Optimization for sPLS method}
\usage{
tuneCluster.spls(
  X,
  Y,
  ncomp = 2,
  test.keepX = rep(ncol(X), ncomp),
  test.keepY = rep(ncol(Y), ncomp),
  ...
)
}
\arguments{
\item{X}{numeric matrix (or data.frame) with features in columns and samples in rows}

\item{Y}{numeric matrix (or data.frame) with features in columns and samples in rows (same rows as \code{X})}

\item{ncomp}{integer, number of component to include in the model}

\item{test.keepX}{vector of integer containing the different value of keepX to test for block \code{X}.}

\item{test.keepY}{vector of integer containing the different value of keepY to test for block \code{Y}.}

\item{...}{other parameters to be included in the spls model (see \code{mixOmics::spls})}
}
\value{
\item{silhouette}{silhouette coef. computed for every combinasion of keepX/keepY}
\item{ncomp}{number of component included in the model}
\item{test.keepX}{list of tested keepX}
\item{test.keepY}{list of tested keepY}
\item{block}{names of blocks}
\item{slopes}{"slopes" computed from the silhouette coef. for each keepX and keepY, used to determine the best keepX and keepY}
\item{choice.keepX}{best \code{keepX} for each component}
\item{choice.keepY}{best \code{keepY} for each component}
}
\description{
This function identify the number of feautures to keep per component and thus by cluster in \code{mixOmics::spls} by optimizing the silhouette coefficient, which assesses the quality of clustering.
}
\details{
For each component and for each keepX/keepY value, a spls is done from these parameters.
Then the clustering is performed and the silhouette coefficient is calculated for this clustering.

We then calculate "slopes" where keepX/keepY are the coordinates and the silhouette is the intensity.
A z-score is assigned to each slope.
We then identify the most significant slope which indicates a drop in the silhouette coefficient and thus a deterioration of the clustering.
}
\examples{
demo <- suppressWarnings(get_demo_cluster())
X <- demo$X
Y <- demo$Y

# tuning
tune.spls <- tuneCluster.spls(X, Y, ncomp= 2, test.keepX= c(5,10,15,20), test.keepY= c(2,4,6))
keepX <- tune.spls$choice.keepX
keepY <- tune.spls$choice.keepY

# final model
spls.res <- mixOmics::spls(X, Y, ncomp= 2, keepX= keepX, keepY= keepY)

# get clusters and plot longitudinal profile by cluster
spls.cluster <- getCluster(spls.res)
plotLong(spls.res)


}
\seealso{
\code{\link[mixOmics]{spls}}, \code{\link[timeOmics]{getCluster}}, \code{\link[timeOmics]{plotLong}}
}
