% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.low.cv.R
\name{remove.low.cv}
\alias{remove.low.cv}
\title{Remove features with low variation}
\usage{
remove.low.cv(X, cutoff = 0.5)
}
\arguments{
\item{X}{a matrix/data.frame}

\item{cutoff}{a numeric value}
}
\value{
a data.frame/matrix
}
\description{
\code{remove.low.cv} that removes variables with low variation.
From a matrix/data.frame (samples in rows, features in columns), it computes the coefficient of variation for every features (columns) 
and return a filtered data.frame with features for which the coefficient of variation is above a given threshold.
}
\examples{
mat <- matrix(sample(1:3, size = 200, replace = TRUE), ncol=20)
remove.low.cv(mat, 0.4)

}
