% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{tof_write_data}
\alias{tof_write_data}
\title{Write high-dimensional cytometry data to a file or to a directory of files}
\usage{
tof_write_data(
  tof_tibble = NULL,
  group_cols,
  out_path = NULL,
  format = c("fcs", "csv"),
  sep = "_",
  file_name
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{group_cols}{Optional. Unquoted names of the columns in `tof_tibble` that should
be used to group cells into separate files. Supports tidyselect helpers. Defaults to
no grouping (all cells are written into a single file).}

\item{out_path}{Path to the directory where output files should be saved.}

\item{format}{format for the files being written. Currently supports .csv and .fcs files}

\item{sep}{Delimiter that should be used between each of the values of `group_cols`
to create the output .csv/.fcs file names. Defaults to "_".}

\item{file_name}{If `group_cols` isn't specified, the name (without an extension)
that should be used for the saved file.}
}
\value{
This function does not explicitly return any values. Instead,
it writes .csv and/or .fcs files to the specified `out_path`.
}
\description{
Write data (in the form of a `tof_tbl`) into either a .csv or an .fcs file for storage.
}
\examples{
NULL

}
\seealso{
Other input/output functions: 
\code{\link{tof_read_data}()},
\code{\link{tof_write_csv}()},
\code{\link{tof_write_fcs}()}
}
\concept{input/output functions}
