% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{tof_transform}
\alias{tof_transform}
\title{Transform raw high-dimensional cytometry data.}
\usage{
tof_transform(
  tof_tibble = NULL,
  channel_cols = where(tof_is_numeric),
  transform_fun
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{channel_cols}{Unquoted column names representing columns that contain
single-cell protein measurements. Supports tidyselect helpers.
If nothing is specified, the default is to transform all numeric columns.}

\item{transform_fun}{A vectorized function to apply to each protein value for
variance stabilization.}
}
\value{
A `tof_tbl` with identical dimensions to the input `tof_tibble`, with all
columns specified in channel_cols transformed using `transform_fun`.
}
\description{
This function transforms a `tof_tbl` of raw ion counts, reads, or
fluorescence intensity units directly measured on a cytometer using a
user-provided function.
}
\examples{

# read in an example .fcs file from tidytof's internal datasets
input_file <- dir(tidytof_example_data("aml"), full.names = TRUE)[[1]]
tof_tibble <- tof_read_data(input_file)

# preprocess all numeric columns with default behavior
# arcsinh transformation with a cofactor of 5
tof_preprocess(tof_tibble)

# preprocess all numeric columns using the log base 10 tranformation
tof_preprocess(tof_tibble, transform_fun = log10)

}
