% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tof_tbl.R
\name{tof_set_panel}
\alias{tof_set_panel}
\title{Set panel information from a tof_tibble}
\usage{
tof_set_panel(tof_tibble, panel)
}
\arguments{
\item{tof_tibble}{A `tof_tbl`.}

\item{panel}{A tibble containing two columns (`metals` and `antigens`) representing
the information about a panel}
}
\value{
A `tof_tibble` containing information about the CyTOF panel
that was used during data acquisition for the data contained
in the input `tof_tibble`. Two columns are required: "metals" and "antigens".
}
\description{
Set panel information from a tof_tibble
}
\examples{
# get current panel from an .fcs file
input_file <- dir(tidytof_example_data("aml"), full.names = TRUE)[[1]]
tof_tibble <- tof_read_data(input_file)
current_panel <- tof_get_panel(tof_tibble)

# create a new panel (remove empty channels)
new_panel <- dplyr::filter(current_panel, antigens != "empty")
tof_set_panel(tof_tibble = tof_tibble, panel = new_panel)

}
\seealso{
Other tof_tbl utilities: 
\code{\link{new_tof_tibble}()},
\code{\link{tof_get_panel}()}
}
\concept{tof_tbl utilities}
