% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{tof_reduce_pca}
\alias{tof_reduce_pca}
\title{Perform principal component analysis on single-cell data}
\usage{
tof_reduce_pca(
  tof_tibble,
  pca_cols = where(tof_is_numeric),
  num_comp = 5,
  threshold = NA,
  center = TRUE,
  scale = TRUE,
  return_recipe = FALSE
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{pca_cols}{Unquoted column names indicating which columns in `tof_tibble` to
use for computing the principal components. Defaults to all numeric columns.
Supports tidyselect helpers.}

\item{num_comp}{The number of PCA components to calculate. Defaults
to 5. See \code{\link[recipes]{step_pca}}.}

\item{threshold}{A double between 0 and 1 representing the fraction of total
variance that should be covered by the components returned in the output. See
\code{\link[recipes]{step_pca}}.}

\item{center}{A boolean value indicating if each column should be centered to
mean 0 before PCA analysis. Defaults to TRUE.}

\item{scale}{A boolean value indicating if each column should be scaled to
standard deviation = 1 before PCA analysis. Defaults to TRUE.}

\item{return_recipe}{A boolean value indicating if instead of the UMAP result, a
prepped \code{\link[recipes]{recipe}} object containing the
PCA embedding should be
returned. Set this option to TRUE if you want to create the PCA embedding using
one dataset but also want to project new observations onto the same embedding
space later.}
}
\value{
A tibble with the same number of rows as `tof_tibble`, each representing
a single cell. Each of the `num_comp` columns represents each cell's embedding
in the calculated principal component space.
}
\description{
This function calculates principal components using single-cell data from a `tof_tibble`.
}
\examples{
# simulate single-cell data
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 200),
        cd38 = rnorm(n = 200),
        cd34 = rnorm(n = 200),
        cd19 = rnorm(n = 200)
    )
new_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 50),
        cd38 = rnorm(n = 50),
        cd34 = rnorm(n = 50),
        cd19 = rnorm(n = 50)
    )

# calculate pca
tof_reduce_pca(tof_tibble = sim_data, num_comp = 2)

# return recipe instead of embeddings
pca_recipe <- tof_reduce_pca(tof_tibble = sim_data, return_recipe = TRUE)

# apply recipe to new data
recipes::bake(pca_recipe, new_data = new_data)

}
\seealso{
Other dimensionality reduction functions: 
\code{\link{tof_reduce_dimensions}()},
\code{\link{tof_reduce_tsne}()},
\code{\link{tof_reduce_umap}()}
}
\concept{dimensionality reduction functions}
