% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{tof_reduce_dimensions}
\alias{tof_reduce_dimensions}
\title{Apply dimensionality reduction to a single-cell dataset.}
\usage{
tof_reduce_dimensions(
  tof_tibble,
  ...,
  augment = TRUE,
  method = c("pca", "tsne", "umap")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{...}{Arguments to be passed to the tof_reduce_* function corresponding to
the embedding method. See \code{\link{tof_reduce_pca}}, \code{\link{tof_reduce_tsne}}, and
\code{\link{tof_reduce_umap}}.}

\item{augment}{A boolean value indicating if the output should column-bind the
dimensionality-reduced embedding vectors of each cell as a new column in `tof_tibble`
(TRUE, the default) or if a tibble including only the low-dimensionality
embeddings should be returned (FALSE).}

\item{method}{A method of dimensionality reduction. Currently, PCA, tSNE, and
UMAP embedding are supported.}
}
\value{
A tibble with the same number of rows as `tof_tibble`, each representing
a single cell. Each of the `num_comp` columns represents each cell's embedding
in the calculated embedding space.
}
\description{
This function is a wrapper around tidytof's tof_reduce_* function family.
It performs dimensionality reduction on single-cell data using a user-specified method
(of 3 choices) and each method's corresponding input parameters
}
\examples{
# simulate single-cell data
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 100),
        cd38 = rnorm(n = 100),
        cd34 = rnorm(n = 100),
        cd19 = rnorm(n = 100)
    )

# calculate pca
tof_reduce_dimensions(tof_tibble = sim_data, method = "pca")

# calculate tsne
tof_reduce_dimensions(tof_tibble = sim_data, method = "tsne")

# calculate umap
tof_reduce_dimensions(tof_tibble = sim_data, method = "umap")

}
\seealso{
Other dimensionality reduction functions: 
\code{\link{tof_reduce_pca}()},
\code{\link{tof_reduce_tsne}()},
\code{\link{tof_reduce_umap}()}
}
\concept{dimensionality reduction functions}
