% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{tof_read_csv}
\alias{tof_read_csv}
\title{Read high-dimensional cytometry data from a .csv file into a tidy tibble.}
\usage{
tof_read_csv(file_path = NULL, panel_info = dplyr::tibble())
}
\arguments{
\item{file_path}{A file path to a single .csv file.}

\item{panel_info}{Optional. A tibble or data.frame containing information about the
panel used during high-dimensional cytometry data acquisition. Two columns are required:
"metals" and "antigens".}
}
\value{
A `tof_tbl` in which each row represents a single cell and each
column represents a high-dimensional cytometry antigen channel.

A `tof_tbl` is an S3 class that extends the "tibble" class by storing
one additional attribute: "panel" (a tibble storing information about the
panel used during data acquisition). Because panel information isn't
obvious from data read as a .csv file, this information must be provided
manually from the user (unlike in `tof_read_fcs`).
}
\description{
Read high-dimensional cytometry data from a .csv file into a tidy tibble.
}
