% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{tof_preprocess}
\alias{tof_preprocess}
\title{Preprocess raw high-dimensional cytometry data.}
\usage{
tof_preprocess(
  tof_tibble = NULL,
  channel_cols = where(tof_is_numeric),
  undo_noise = FALSE,
  transform_fun = function(x) asinh(x/5)
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{channel_cols}{Unquoted column names representing columns that contain
single-cell protein measurements. Supports tidyselect helpers.
If nothing is specified, the default is to transform all numeric columns.}

\item{undo_noise}{A boolean value indicating whether to remove the uniform noise that
Fluidigm software adds to CyTOF measurements for aesthetic
and visualization purposes. See \href{https://pubmed.ncbi.nlm.nih.gov/30277658/}{this paper}.
Defaults to FALSE.}

\item{transform_fun}{A vectorized function to apply to each protein value for
variance stabilization. Defaults to \code{\link[base]{asinh}} transformation
(with a co-factor of 5).}
}
\value{
A `tof_tbl` with identical dimensions to the input `tof_tibble`, with all
columns specified in channel_cols transformed using `transform_fun` (with noise
removed or not removed depending on `undo_noise`).
}
\description{
This function transforms a `tof_tbl` of raw ion counts, reads, or
fluorescence intensity units directly measured on a cytometer using a
user-provided function. It can be used to perform
standard pre-processing steps (i.e. arcsinh transformation) before cytometry
data analysis.
}
\examples{

# read in an example .fcs file from tidytof's internal datasets
input_file <- dir(tidytof_example_data("aml"), full.names = TRUE)[[1]]
tof_tibble <- tof_read_data(input_file)

# preprocess all numeric columns with default behavior
# arcsinh transformation with a cofactor of 5
tof_preprocess(tof_tibble)

# preprocess all numeric columns using the log base 10 tranformation
tof_preprocess(tof_tibble, transform_fun = log10)

}
\seealso{
[tof_postprocess()]
}
