% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patient-level_modeling.R
\name{tof_predict}
\alias{tof_predict}
\title{Use a trained elastic net model to predict fitted values from new data}
\usage{
tof_predict(
  tof_model,
  new_data,
  prediction_type = c("response", "class", "link", "survival curve")
)
}
\arguments{
\item{tof_model}{A `tof_model` trained using \code{\link{tof_train_model}}}

\item{new_data}{A tibble of new observations for which predictions should be made.
If new_data isn't provided, predictions will be made for the training data used to
fit the model.}

\item{prediction_type}{A string indicating which type of prediction should be
provided by the model:

\describe{
\item{"response" (the default)}{For "linear" models, the predicted response
for each observation. For "two-class" and "multiclass" models, the fitted
probabilities of each class for each observation. For "survival" models, the fitted relative-risk
for each observation.}
\item{"class"}{Only applies to "two-class" and "multiclass" models. For both,
the class label corresponding to the class with the maximum fitted probability.}
\item{"link"}{The linear predictions of the model
(the output of the link function for each model family.)}
\item{"survival curve"}{Only applies to "survival" models. Returns a tibble
indicating each patient's probability of survival (1 - probability(event))
at each timepoint in the dataset. Obtained using the
\code{\link[survival]{survfit}} function.}
}}
}
\value{
A \code{\link[dplyr]{tibble}} with a single column (`.pred`) containing
the predictions or, for multiclass models with `prediction_type` == "response",
a tibble with one column for each class. Each row in the output corresponds to a row in `new_data` (
or, if `new_data` is not provided, to a row in the `tof_model`'s training data).
In the latter case, be sure to check `tof_model$training_data` to confirm the
order of observations, as the resampling procedure can change their ordering
relative to the original input data.
}
\description{
This function uses a trained `tof_model` to make predictions on new data.
}
\examples{
feature_tibble <-
    dplyr::tibble(
        sample = as.character(1:100),
        cd45 = runif(n = 100),
        pstat5 = runif(n = 100),
        cd34 = runif(n = 100),
        outcome = (3 * cd45) + (4 * pstat5) + rnorm(100)
    )

new_tibble <-
    dplyr::tibble(
        sample = as.character(1:20),
        cd45 = runif(n = 20),
        pstat5 = runif(n = 20),
        cd34 = runif(n = 20),
        outcome = (3 * cd45) + (4 * pstat5) + rnorm(20)
    )

split_data <- tof_split_data(feature_tibble, split_method = "simple")

# train a regression model
regression_model <-
    tof_train_model(
        split_data = split_data,
        predictor_cols = c(cd45, pstat5, cd34),
        response_col = outcome,
        model_type = "linear"
    )

# apply the model to new data
tof_predict(tof_model = regression_model, new_data = new_tibble)

}
\seealso{
Other modeling functions: 
\code{\link{tof_assess_model}()},
\code{\link{tof_create_grid}()},
\code{\link{tof_split_data}()},
\code{\link{tof_train_model}()}
}
\concept{modeling functions}
