% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{tof_postprocess}
\alias{tof_postprocess}
\title{Post-process transformed CyTOF data.}
\usage{
tof_postprocess(
  tof_tibble = NULL,
  channel_cols = where(tof_is_numeric),
  redo_noise = FALSE,
  transform_fun = function(x) rev_asinh(x, shift_factor = 0, scale_factor = 0.2)
)
}
\arguments{
\item{tof_tibble}{A `tof_tibble` or a `tibble`.}

\item{channel_cols}{A vector of non-quoted column names indicating which columns
in `tof_tibble` contain protein measurements. Supports tidyselect helpers.
If nothing is specified, the default is to transform all numeric columns.}

\item{redo_noise}{A boolean value indicating whether to add  uniform noise that
to each CyTOF measurement for aesthetic and visualization purposes. See \href{https://pubmed.ncbi.nlm.nih.gov/30277658/}{this paper}.
Defaults to FALSE}

\item{transform_fun}{A vectorized function to apply to each column specified by
`channel_cols` for post-processing. Defaults to \code{\link{rev_asinh}} transformation
(with a cofactor of 5).}
}
\value{
A `tof_tbl` with identical dimensions to the input `tof_tibble`, with all
columns specified in channel_cols transformed using `transform_fun` (with noise
added or not removed depending on `redo_noise`).
}
\description{
This function transforms a `tof_tibble` of transformed ion counts from a mass
cytometer back into something that looks more like an .fcs file that Fluidigm
software generates.
}
\examples{

# read in an example .fcs file from tidytof's internal datasets
input_file <- dir(tidytof_example_data("aml"), full.names = TRUE)[[1]]
tof_tibble <- tof_read_data(input_file)

# preprocess all numeric columns with default behavior
# arcsinh transformation with a cofactor of 5
preprocessed_tof_tibble <- tof_preprocess(tof_tibble)

# postprocess all numeric columns to reverse the preprocessing
tof_postprocess(tof_tibble)

}
\seealso{
[tof_preprocess()]
}
