% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_sample_heatmap}
\alias{tof_plot_sample_heatmap}
\title{Make a heatmap summarizing sample marker expression patterns in CyTOF data}
\usage{
tof_plot_sample_heatmap(
  tof_tibble,
  sample_col,
  marker_cols = where(tof_is_numeric),
  central_tendency_function = stats::median,
  scale_markerwise = FALSE,
  scale_samplewise = FALSE,
  line_width = 0.25,
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{sample_col}{An unquoted column name indicating which column in `tof_tibble`
stores the ids for the sample to which each cell belongs.}

\item{marker_cols}{Unquoted column names indicating which column in `tof_tibble`
should be interpreted as markers to be plotted along the x-axis of the heatmap.
Supports tidyselect helpers.}

\item{central_tendency_function}{A function to use for computing the
measure of central tendency that will be aggregated from each sample in
cluster_col. Defaults to the median.}

\item{scale_markerwise}{A boolean value indicating if the heatmap should
rescale the columns of the heatmap such that the maximum value for each
marker is 1 and the minimum value is 0. Defaults to FALSE.}

\item{scale_samplewise}{A boolean value indicating if the heatmap should
rescale the rows of the heatmap such that the maximum value for each
sample is 1 and the minimum value is 0. Defaults to FALSE.}

\item{line_width}{A numeric value indicating how thick the lines separating
the tiles of the heatmap should be. Defaults to 0.25.}

\item{theme}{A ggplot2 theme to apply to the heatmap.
Defaults to \code{\link[ggplot2]{theme_minimal}}}
}
\value{
A ggplot object.
}
\description{
This function makes a heatmap of sample-to-sample marker expression patterns
in single-cell data. Markers are plotted along the horizontal (x-) axis of
the heatmap and sample IDs are plotted along the vertical (y-) axis of the
heatmap.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        sample_id = sample(paste0("sample", 1:5), size = 1000, replace = TRUE)
    )

heatmap <-
    tof_plot_sample_heatmap(
        tof_tibble = sim_data,
        sample_col = sample_id
    )

}
