% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_sample_features}
\alias{tof_plot_sample_features}
\title{Make a heatmap summarizing sample marker expression patterns in CyTOF data}
\usage{
tof_plot_sample_features(
  feature_tibble,
  sample_col,
  feature_cols = where(tof_is_numeric),
  scale_featurewise = FALSE,
  scale_samplewise = FALSE,
  line_width = 0.25,
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{feature_tibble}{A tbl_df or data.frame of aggregated sample-level features,
such as that generated by \code{\link{tof_extract_features}}.}

\item{sample_col}{An unquoted column name indicating which column in `tof_tibble`
stores the IDs for each sample. If no sample IDs are present, a numeric ID
will be assigned to each row of `feature_tibble` based on its row index.}

\item{feature_cols}{Unquoted column names indicating which column in `feature_tibble`
should be interpreted as features to be plotted along the x-axis of the heatmap.
Supports tidyselect helpers.}

\item{scale_featurewise}{A boolean value indicating if the heatmap should
rescale the columns of the heatmap such that the maximum value for each
marker is 1 and the minimum value is 0. Defaults to FALSE.}

\item{scale_samplewise}{A boolean value indicating if the heatmap should
rescale the rows of the heatmap such that the maximum value for each
sample is 1 and the minimum value is 0. Defaults to FALSE.}

\item{line_width}{A numeric value indicating how thick the lines separating
the tiles of the heatmap should be. Defaults to 0.25.}

\item{theme}{A ggplot2 theme to apply to the heatmap.
Defaults to \code{\link[ggplot2]{theme_minimal}}}
}
\value{
A ggplot object.
}
\description{
This function makes a heatmap of sample-to-sample marker expression patterns
in single-cell data. Markers are plotted along the horizontal (x-) axis of
the heatmap and sample IDs are plotted along the vertical (y-) axis of the
heatmap.
}
\examples{

# simulate single-cell data
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE),
        sample_id = sample(paste0("sample", 1:5), size = 1000, replace = TRUE)
    )

# extract cluster proportions in each simulated patient
feature_data <-
    tof_extract_proportion(
        tof_tibble = sim_data,
        cluster_col = cluster_id,
        group_cols = sample_id
    )

# plot the heatmap
heatmap <- tof_plot_sample_features(feature_tibble = feature_data)

}
