% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_model}
\alias{tof_plot_model}
\title{Plot the results of a glmnet model fit on sample-level data.}
\usage{
tof_plot_model(tof_model, new_data, theme = ggplot2::theme_bw())
}
\arguments{
\item{tof_model}{A `tof_model` trained using \code{\link{tof_train_model}}}

\item{new_data}{A tibble of new observations for which a plot should be made.
If new_data isn't provided, the plot will be made using the training data used to
fit the model. Alternatively, the string "tuning_data" can be provided, and the
plot will be generated using the predictions generated during model tuning.}

\item{theme}{A ggplot2 theme to apply to the plot
Defaults to \code{\link[ggplot2]{theme_bw}}}
}
\value{
A ggplot object. If the `tof_model` is a linear model, a scatterplot
of the predicted outcome vs. the true outcome will be returned. If the `tof_model`
is a two-class model, an ROC curve will be returned. If the `tof_model` is a
multiclass model, a one-versus-all ROC curve will be returned for each class.
If `tof_model` is a survival model, a Kaplan-Meier curve will be returned.
}
\description{
Plot the results of a glmnet model fit on sample-level data.
}
\examples{
feature_tibble <-
    dplyr::tibble(
        sample = as.character(1:100),
        cd45 = runif(n = 100),
        pstat5 = runif(n = 100),
        cd34 = runif(n = 100),
        outcome = (3 * cd45) + (4 * pstat5) + rnorm(100),
        class =
            as.factor(
                dplyr::if_else(outcome > median(outcome), "class1", "class2")
            )
    )

new_tibble <-
    dplyr::tibble(
        sample = as.character(1:20),
        cd45 = runif(n = 20),
        pstat5 = runif(n = 20),
        cd34 = runif(n = 20),
        outcome = (3 * cd45) + (4 * pstat5) + rnorm(20),
        class =
            as.factor(
                dplyr::if_else(outcome > median(outcome), "class1", "class2")
            )
    )

split_data <- tof_split_data(feature_tibble, split_method = "simple")

# train a regression model
regression_model <-
    tof_train_model(
        split_data = split_data,
        predictor_cols = c(cd45, pstat5, cd34),
        response_col = outcome,
        model_type = "linear"
    )

# make the plot
plot_1 <- tof_plot_model(tof_model = regression_model, new_data = new_tibble)

# train a logistic regression classifier
logistic_model <-
    tof_train_model(
        split_data = split_data,
        predictor_cols = c(cd45, pstat5, cd34),
        response_col = class,
        model_type = "two-class"
    )

# make the plot

plot_2 <- tof_plot_model(tof_model = logistic_model, new_data = new_tibble)

}
