% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tof_plot_heatmap}
\alias{tof_plot_heatmap}
\title{Make a heatmap summarizing group marker expression patterns in high-dimensional cytometry data}
\usage{
tof_plot_heatmap(
  tof_tibble,
  y_col,
  marker_cols = where(tof_is_numeric),
  central_tendency_function = stats::median,
  scale_markerwise = FALSE,
  scale_ywise = FALSE,
  cluster_markers = TRUE,
  cluster_groups = TRUE,
  line_width = 0.25,
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{y_col}{An unquoted column name indicating which column in `tof_tibble`
stores the ids for the group to which each cell belongs.}

\item{marker_cols}{Unquoted column names indicating which column in `tof_tibble`
should be interpreted as markers to be plotted along the x-axis of the heatmap.
Supports tidyselect helpers.}

\item{central_tendency_function}{A function to use for computing the
measure of central tendency that will be aggregated from each cluster in
cluster_col. Defaults to the median.}

\item{scale_markerwise}{A boolean value indicating if the heatmap should
rescale the columns of the heatmap such that the maximum value for each
marker is 1 and the minimum value is 0. Defaults to FALSE.}

\item{scale_ywise}{A boolean value indicating if the heatmap should
rescale the rows of the heatmap such that the maximum value for each
group is 1 and the minimum value is 0. Defaults to FALSE.}

\item{cluster_markers}{A boolean value indicating if the heatmap should
order its columns (i.e. markers) using hierarchical clustering. Defaults to
TRUE.}

\item{cluster_groups}{A boolean value indicating if the heatmap should
order its rows (i.e. groups) using hierarchical clustering. Defaults to
TRUE.}

\item{line_width}{A numeric value indicating how thick the lines separating
the tiles of the heatmap should be. Defaults to 0.25.}

\item{theme}{A ggplot2 theme to apply to the heatmap.
Defaults to \code{\link[ggplot2]{theme_minimal}}}
}
\value{
A ggplot object.
}
\description{
This function makes a heatmap of group-to-group marker expression patterns
in single-cell data. Markers are plotted along the horizontal (x-) axis of
the heatmap and groups are plotted along the vertical (y-) axis of the
heatmap.
}
