% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_clusters_volcano}
\alias{tof_plot_clusters_volcano}
\title{Create a volcano plot from differential expression analysis results}
\usage{
tof_plot_clusters_volcano(
  dea_result,
  num_top_pairs = 10L,
  alpha = 0.05,
  point_size = 2,
  label_size = 3,
  nudge_x = 0,
  nudge_y = 0.25,
  increase_color = "#207394",
  decrease_color = "#cd5241",
  insignificant_color = "#cdcdcd",
  use_ggrepel = FALSE,
  theme = ggplot2::theme_bw()
)
}
\arguments{
\item{dea_result}{A tibble containing the differential expression analysis (DEA)
results produced by one of the members of the `tof_dea_*` function family.}

\item{num_top_pairs}{An integer representing the number of most significant
cluster-marker pairs that should be labeled in the volcano plot.}

\item{alpha}{A numeric value between 0 and 1 representing the significance
level below which a p-value should be considered
statistically significant. Defaults to 0.05.}

\item{point_size}{A numeric value specifying the size of the points in the
volcano plot.}

\item{label_size}{A numeric value specifying the size of the text labeling
cluster-marker pairs.}

\item{nudge_x}{A numeric value specifying how far cluster-marker pair labels
should be adjusted to the left (if `nudge_x` is negative) or to the right
(if `nudge_x` is positive) to avoid overlap with the plotted points.
Passed to  \code{\link[ggplot2]{geom_text}}, and ignored if
`use_ggrepel` = TRUE. Defaults to 0.}

\item{nudge_y}{A numeric value specifying how far cluster-marker pair labels
should be adjusted downwards (if `nudge_y` is negative) or upwards
(if `nudge_y` is positive) to avoid overlap with the plotted points.
Passed to  \code{\link[ggplot2]{geom_text}}, and ignored if
`use_ggrepel` = TRUE. Defaults to 0.25.}

\item{increase_color}{A hex code specifying which fill color should
be used for points corresponding to cluster-marker pairs where significant
increases were detected.}

\item{decrease_color}{A hex code specifying which fill color should
be used for points corresponding to cluster-marker pairs where significant
decreases were detected.}

\item{insignificant_color}{A hex code specifying which fill color should
be used for points corresponding to cluster-marker pairs where no significant
differences were detected.}

\item{use_ggrepel}{A boolean value indicting if
\code{\link[ggrepel]{geom_text_repel}} should be used to plot labels for
cluster-marker pairs. Defaults to FALSE.
If TRUE, the ggrepel package must be installed.}

\item{theme}{A ggplot2 theme to apply to the volcano plot.
Defaults to \code{\link[ggplot2]{theme_bw}}}
}
\value{
A ggplot object.
}
\description{
This function makes a volcano plot using the results of a differential
expression analysis (DEA) produced by one of the `tof_dea_*` verbs. Each
point in the volcano plot represents a single cluster-marker pair, colored by
significance level and the direction of the marker expression difference.
}
\examples{

# create a mock differential expression analysis result
sim_dea_result <-
    dplyr::tibble(
        cluster_id = rep(letters, 2),
        marker = rep(c("cd45", "cd34"), times = length(letters)),
        p_adj = runif(n = 2 * length(letters), min = 0, max = 0.5),
        mean_fc = runif(n = 2 * length(letters), min = 0.01, max = 10),
        significant = dplyr::if_else(p_adj < 0.05, "*", "")
    )

attr(sim_dea_result, which = "dea_method") <- "t_unpaired"

# create the volcano plot
volcano <- tof_plot_clusters_volcano(dea_result = sim_dea_result)

}
