% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_clusters_heatmap}
\alias{tof_plot_clusters_heatmap}
\title{Make a heatmap summarizing cluster marker expression patterns in CyTOF data}
\usage{
tof_plot_clusters_heatmap(
  tof_tibble,
  cluster_col,
  marker_cols = where(tof_is_numeric),
  central_tendency_function = stats::median,
  scale_markerwise = FALSE,
  scale_clusterwise = FALSE,
  cluster_markers = TRUE,
  cluster_clusters = TRUE,
  line_width = 0.25,
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
stores the cluster ids for the cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{marker_cols}{Unquoted column names indicating which column in `tof_tibble`
should be interpreted as markers to be plotted along the x-axis of the heatmap.
Supports tidyselect helpers.}

\item{central_tendency_function}{A function to use for computing the
measure of central tendency that will be aggregated from each cluster in
cluster_col. Defaults to the median.}

\item{scale_markerwise}{A boolean value indicating if the heatmap should
rescale the columns of the heatmap such that the maximum value for each
marker is 1 and the minimum value is 0. Defaults to FALSE.}

\item{scale_clusterwise}{A boolean value indicating if the heatmap should
rescale the rows of the heatmap such that the maximum value for each
cluster is 1 and the minimum value is 0. Defaults to FALSE.}

\item{cluster_markers}{A boolean value indicating if the heatmap should
order its columns (i.e. markers) using hierarchical clustering. Defaults to
TRUE.}

\item{cluster_clusters}{A boolean value indicating if the heatmap should
order its rows (i.e. clusters) using hierarchical clustering. Defaults to
TRUE.}

\item{line_width}{A numeric value indicating how thick the lines separating
the tiles of the heatmap should be. Defaults to 0.25.}

\item{theme}{A ggplot2 theme to apply to the heatmap.
Defaults to \code{\link[ggplot2]{theme_minimal}}}
}
\value{
A ggplot object.
}
\description{
This function makes a heatmap of cluster-to-cluster marker expression patterns
in single-cell data. Markers are plotted along the horizontal (x-) axis of
the heatmap and cluster IDs are plotted along the vertical (y-) axis of the
heatmap.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE)
    )

heatmap <-
    tof_plot_clusters_heatmap(
        tof_tibble = sim_data,
        cluster_col = cluster_id
    )

}
