% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_cells_scatter}
\alias{tof_plot_cells_scatter}
\title{Plot scatterplots of single-cell data.}
\usage{
tof_plot_cells_scatter(
  tof_tibble,
  x_col,
  y_col,
  color_col,
  facet_cols,
  theme = ggplot2::theme_bw(),
  ...,
  method = c("ggplot2", "scattermore")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{x_col}{An unquoted column name specifying which column in
`tof_tibble` should be used as the x-axis.}

\item{y_col}{An unquoted column name specifying which column in
`tof_tibble` should be used as the y-axis.}

\item{color_col}{An unquoted column name specifying which column in
`tof_tibble` should be used to color each point in the scatterplot.}

\item{facet_cols}{An unquoted column name specifying which column in
`tof_tibble` should be used to break the scatterplot into facets using
\code{\link[ggplot2]{facet_wrap}}.}

\item{theme}{A ggplot2 theme to apply to the scatterplot. Defaults to
\code{\link[ggplot2]{theme_bw}}.}

\item{...}{Optional additional arguments to pass to \code{\link[ggplot2]{geom_point}}
if \code{method = "ggplot2"} or \code{\link[scattermore]{geom_scattermore}} if
\code{method = "scattermore"}.}

\item{method}{A string indicating which plotting engine should be used. Valid
values include "ggplot2" (the default) and "scattermore" (recommended if more than
100K cells are being plotted). Note that \code{method = "scattermore"} requires the
scattermore package to be installed.}
}
\value{
A ggplot object.
}
\description{
This function makes scatterplots of single-cell data using user-specified
x- and y-axes. Additionally, each point in the scatterplot can be colored
using a user-specified variable.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = c(rnorm(n = 500), rnorm(n = 500, mean = 2)),
        cd34 = c(rnorm(n = 500), rnorm(n = 500, mean = 4)),
        cd19 = rnorm(n = 1000),
        cluster_id = c(rep("a", 500), rep("b", 500))
    )

}
\seealso{
Other visualization functions: 
\code{\link{tof_plot_cells_embedding}()},
\code{\link{tof_plot_cells_layout}()}
}
\concept{visualization functions}
