% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_cells_layout}
\alias{tof_plot_cells_layout}
\title{Plot force-directed layouts of single-cell data}
\usage{
tof_plot_cells_layout(
  tof_tibble,
  knn_cols = where(tof_is_numeric),
  color_col,
  facet_cols,
  num_neighbors = 5,
  graph_type = c("weighted", "unweighted"),
  graph_layout = "fr",
  distance_function = c("euclidean", "cosine"),
  edge_alpha = 0.25,
  node_size = 2,
  theme = ggplot2::theme_void(),
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{knn_cols}{Unquoted column names indicating which columns in `tof_tibble`
should be used to compute the cell-to-cell distances used to construct
the k-nearest-neighbor graph. Supports tidyselect helpers. Defaults to all
numeric columns.}

\item{color_col}{Unquoted column name indicating which column in `tof_tibble`
should be used to color the nodes in the force-directed layout.}

\item{facet_cols}{Unquoted column names indicating which columns in `tof_tibble`
should be used to separate nodes into different force-directed layouts.}

\item{num_neighbors}{An integer specifying how many neighbors should be used
to construct the k-nearest neighbor graph.}

\item{graph_type}{A string specifying if the k-nearest neighbor graph should
be "weighted" (the default) or "unweighted".}

\item{graph_layout}{A string specifying which algorithm should be used to
compute the force-directed layout. Passed to \code{\link[ggraph]{ggraph}}.
Defaults to "fr", the Fruchterman-Reingold algorithm. Other examples include
"nicely", "gem", "kk", and many others. See
\code{\link[ggraph]{layout_tbl_graph_igraph}} for other examples.}

\item{distance_function}{A string indicating which distance function to use
in computing the cell-to-cell distances. Valid options include "euclidean"
(the default) and "cosine".}

\item{edge_alpha}{A numeric value between 0 and 1 specifying the transparency
of the edges drawn in the force-directed layout. Defaults to 0.25.}

\item{node_size}{A numeric value specifying the size of the nodes in the
force-directed layout. Defaults to 2.}

\item{theme}{A ggplot2 theme to apply to the force-directed layout.
Defaults to \code{\link[ggplot2]{theme_void}}}

\item{...}{\code{\link[RcppHNSW]{hnsw_knn}}}
}
\value{
A ggraph/ggplot object.
}
\description{
This function makes force-directed layouts using single-cell data embedded in
a 2-dimensional space representing a k-nearest-neighbor graph constructed
using cell-to-cell similarities. Each node in the force-directed layout
represents a single cell colored using a user-specified variable.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = c(rnorm(n = 500), rnorm(n = 500, mean = 2)),
        cd34 = c(rnorm(n = 500), rnorm(n = 500, mean = 4)),
        cd19 = rnorm(n = 1000),
        cluster_id = c(rep("a", 500), rep("b", 500))
    )

# make a layout colored by a marker
layout_cd38 <-
    tof_plot_cells_layout(
        tof_tibble = sim_data,
        color_col = cd38
    )

# make a layout colored by cluster id
layout_cluster <-
    tof_plot_cells_layout(
        tof_tibble = sim_data,
        color_col = cluster_id,
    )

}
\seealso{
Other visualization functions: 
\code{\link{tof_plot_cells_embedding}()},
\code{\link{tof_plot_cells_scatter}()}
}
\concept{visualization functions}
