% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_cells_embedding}
\alias{tof_plot_cells_embedding}
\title{Plot scatterplots of single-cell data using low-dimensional feature embeddings}
\usage{
tof_plot_cells_embedding(
  tof_tibble,
  embedding_cols,
  color_col,
  facet_cols,
  compute_embedding_cols = where(tof_is_numeric),
  embedding_method = c("pca", "tsne", "umap"),
  embedding_args = list(),
  theme = ggplot2::theme_bw(),
  ...,
  method = c("ggplot2", "scattermore")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{embedding_cols}{Unquoted column names indicating which columns in
`tof_tibble` should be used as the x and y axes of the scatterplot. Supports
tidyselect helpers. Must select exactly 2 columns. If not provided, a
feature embedding can be computed from scratch using the method provided
using the `embedding_method` argument and the
\code{\link{tof_reduce_dimensions}} arguments passed to `embedding_args`.}

\item{color_col}{An unquoted column name specifying which column in
`tof_tibble` should be used to color each point in the scatterplot.}

\item{facet_cols}{An unquoted column name specifying which column in
`tof_tibble` should be used to break the scatterplot into facets using
\code{\link[ggplot2]{facet_wrap}}.}

\item{compute_embedding_cols}{Unquoted column names indicating which columns
in 'tof_tibble' to use for computing the embeddings with the method specified
by `embedding_method`. Defaults to all numeric columns in 'tof_tibble'.
Supports tidyselect helpers.}

\item{embedding_method}{A string indicating which method should be used for
the feature embedding (if `embedding_cols` are not provided). Options
(which are passed to \code{\link{tof_reduce_dimensions}}) are "pca" (the default),
"tsne", and "umap".}

\item{embedding_args}{Optional additional arguments to pass to
\code{\link{tof_reduce_dimensions}}. For example, for `method = "tsne"`, these
might include `num_comp`, `perplexity`, and `theta`.}

\item{theme}{A ggplot2 theme to apply to the scatterplot. Defaults to
\code{\link[ggplot2]{theme_bw}}.}

\item{...}{Optional additional arguments to pass to
\code{\link{tof_plot_cells_scatter}}.}

\item{method}{A string indicating which plotting engine should be used. Valid
values include "ggplot2" (the default) and "scattermore" (recommended if more than
100K cells are being plotted). Note that \code{method = "scattermore"} requires the
scattermore package to be installed.}
}
\value{
A ggplot object.
}
\description{
This function makes scatterplots using single-cell data embedded in a
low-dimensional space (such as that generated by
\code{\link{tof_reduce_dimensions}}, with each point colored using a
user-specified variable.
}
\examples{

sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = c(rnorm(n = 500), rnorm(n = 500, mean = 2)),
        cd34 = c(rnorm(n = 500), rnorm(n = 500, mean = 4)),
        cd19 = rnorm(n = 1000),
        cluster_id = c(rep("a", 500), rep("b", 500))
    )

# embed with pca
pca_plot <-
    tof_plot_cells_embedding(
        tof_tibble = sim_data,
        color_col = cd38,
        embedding_method = "pca",
        compute_embedding_cols = starts_with("cd")
    )

# embed with tsne
tsne_plot <-
    tof_plot_cells_embedding(
        tof_tibble = sim_data,
        color_col = cluster_id,
        embedding_method = "tsne",
        compute_embedding_cols = starts_with("cd")
    )

}
\seealso{
Other visualization functions: 
\code{\link{tof_plot_cells_layout}()},
\code{\link{tof_plot_cells_scatter}()}
}
\concept{visualization functions}
