% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{tof_plot_cells_density}
\alias{tof_plot_cells_density}
\title{Plot marker expression density plots}
\usage{
tof_plot_cells_density(
  tof_tibble,
  marker_col,
  group_col,
  num_points = 512,
  theme = ggplot2::theme_bw(),
  use_ggridges = FALSE,
  scale = 1,
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{marker_col}{An unquoted column name representing which column in `tof_tibble`
(i.e. which CyTOF protein measurement) should be included in the feature extraction
calculation.}

\item{group_col}{Unquoted column names representing which column in `tof_tibble`
should be used to break the rows of `tof_tibble` into subgroups to be plotted
as separate histograms. Defaults to plotting without subgroups.}

\item{num_points}{The number of points along the full range of `marker_col` at
which the density should be calculated}

\item{theme}{The ggplot2 theme for the plot. Defaults to
\code{\link[ggplot2]{theme_bw}}}

\item{use_ggridges}{A boolean value indicting if
\code{\link[ggridges]{geom_ridgeline}} should be used to plot overlain
histograms. Defaults to FALSE. If TRUE, the ggridges package must be installed.}

\item{scale}{Use to set the `scale` argument in \code{\link[ggridges]{geom_ridgeline}},
which controls how far apart (vertically) density plots are arranged along the
y-axis. Defaults to 1.}

\item{...}{Additional optional arguments to send to \code{\link[ggridges]{geom_ridgeline}}.}
}
\value{
A ggplot object
}
\description{
This function plots marker expression density plots for a user-specified
column in a tof_tbl. Optionally, cells can be grouped to plot multiple
vertically-arranged density plots
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(c("a", "b"), size = 1000, replace = TRUE)
    )

density_plot <-
    tof_plot_cells_density(
        tof_tibble = sim_data,
        marker_col = cd45,
        group_col = cluster_id
    )

}
