% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaclustering.R
\name{tof_metacluster_phenograph}
\alias{tof_metacluster_phenograph}
\title{Metacluster clustered CyTOF data using PhenoGraph clustering}
\usage{
tof_metacluster_phenograph(
  tof_tibble,
  cluster_col,
  metacluster_cols = where(tof_is_numeric),
  central_tendency_function = stats::median,
  num_neighbors = 5L,
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
stores the cluster ids for the cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{metacluster_cols}{Unquoted column names indicating which columns in
`tof_tibble` to use in computing the metaclusters.
Defaults to all numeric columns in `tof_tibble`. Supports tidyselect helpers.}

\item{central_tendency_function}{The function that should be used to
calculate the measurement of central tendency for each cluster before
metaclustering. This function will be used to compute a summary statistic for
each input cluster in `cluster_col` across all columns specified by
`metacluster_cols`, and the resulting vector (one for each cluster) will be
used as the input for metaclustering.
Defaults to \code{\link[stats]{median}}.}

\item{num_neighbors}{An integer indicating the number of neighbors to use when
constructing PhenoGraph's k-nearest-neighbor graph. Smaller values emphasize
local graph structure; larger values emphasize global graph structure (and
will add time to the computation). Defaults to 5.}

\item{...}{Optional additional method specifications to pass to
\code{\link{tof_cluster_phenograph}}.}
}
\value{
A tibble with a single column (`.phenograph_metacluster`) and
the same number of rows as the input `tof_tibble`. Each entry in the column
indicates the metacluster label assigned to the same row in `tof_tibble`.
}
\description{
This function performs PhenoGraph metaclustering on a `tof_tbl` containing CyTOF data
using a user-specified selection of input variables/CyTOF measurements. The number
of metaclusters is automatically detected by the PhenoGraph algorithm.
See \code{\link{tof_cluster_phenograph}}.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE)
    )

tof_metacluster_phenograph(tof_tibble = sim_data, cluster_col = cluster_id)

}
\seealso{
Other metaclustering functions: 
\code{\link{tof_metacluster}()},
\code{\link{tof_metacluster_consensus}()},
\code{\link{tof_metacluster_flowsom}()},
\code{\link{tof_metacluster_hierarchical}()},
\code{\link{tof_metacluster_kmeans}()}
}
\concept{metaclustering functions}
