% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaclustering.R
\name{tof_metacluster_flowsom}
\alias{tof_metacluster_flowsom}
\title{Metacluster clustered CyTOF data using FlowSOM's built-in metaclustering algorithm}
\usage{
tof_metacluster_flowsom(
  tof_tibble,
  cluster_col,
  metacluster_cols = where(tof_is_numeric),
  central_tendency_function = stats::median,
  num_metaclusters = 10L,
  clustering_algorithm = c("consensus", "hierarchical", "kmeans", "som"),
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
stores the cluster ids for the cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{metacluster_cols}{Unquoted column names indicating which columns in
`tof_tibble` to use in computing the metaclusters.
Defaults to all numeric columns in `tof_tibble`. Supports tidyselect helpers.}

\item{central_tendency_function}{The function that should be used to
calculate the measurement of central tendency for each cluster before
metaclustering. This function will be used to compute a summary statistic for
each input cluster in `cluster_col` across all columns specified by
`metacluster_cols`, and the resulting vector (one for each cluster) will be
used as the input for metaclustering.
Defaults to \code{\link[stats]{median}}.}

\item{num_metaclusters}{An integer indicating the maximum number of clusters
that should be returned. Defaults to 10. Note that for this function, the output
may provide a small number of metaclusters than requested. This is because
\code{\link[FlowSOM]{MetaClustering}} uses the "Elbow method" to automatically
detect the optimal number of metaclusters.}

\item{clustering_algorithm}{A string indicating which clustering algorithm
\code{\link[FlowSOM]{MetaClustering}} should use to perform the metaclustering.
Options are "consensus" (the default), "hierarchical", "kmeans", and "som"
(i.e. self-organizing map; the FlowSOM algorithm itself).}

\item{...}{Optional additional arguments to pass to
\code{\link[FlowSOM]{MetaClustering}}.}
}
\value{
A tibble with a single column (`.flowsom_metacluster`) and
the same number of rows as the input `tof_tibble`. Each entry in the column
indicates the metacluster label assigned to the same row in `tof_tibble`.
}
\description{
This function performs metaclustering on a `tof_tbl` containing CyTOF data
using a user-specified selection of input variables/CyTOF measurements and
the number of desired metaclusters. It takes advantage of the FlowSOM package's
built-in functionality for automatically detecting the number of metaclusters
and can use several strategies as adapted by the FlowSOM team: consensus
metaclustering, hierarchical metaclustering, k-means metaclustering, or
metaclustering using the FlowSOM algorithm itself.
See \code{\link[FlowSOM]{MetaClustering}} for additional
details.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE)
    )

tof_metacluster_flowsom(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    clustering_algorithm = "consensus"
)

tof_metacluster_flowsom(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    clustering_algorithm = "som"
)

}
\seealso{
Other metaclustering functions: 
\code{\link{tof_metacluster}()},
\code{\link{tof_metacluster_consensus}()},
\code{\link{tof_metacluster_hierarchical}()},
\code{\link{tof_metacluster_kmeans}()},
\code{\link{tof_metacluster_phenograph}()}
}
\concept{metaclustering functions}
