% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaclustering.R
\name{tof_metacluster}
\alias{tof_metacluster}
\title{Metacluster clustered CyTOF data.}
\usage{
tof_metacluster(
  tof_tibble,
  cluster_col,
  metacluster_cols = where(tof_is_numeric),
  central_tendency_function = stats::median,
  ...,
  augment = TRUE,
  method = c("consensus", "hierarchical", "kmeans", "phenograph", "flowsom")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
stores the cluster ids for the cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{metacluster_cols}{Unquoted column names indicating which columns in
`tof_tibble` to use in computing the metaclusters.
Defaults to all numeric columns in `tof_tibble`. Supports tidyselect helpers.}

\item{central_tendency_function}{The function that should be used to
calculate the measurement of central tendency for each cluster before
metaclustering. This function will be used to compute a summary statistic for
each input cluster in `cluster_col` across all columns specified by
`metacluster_cols`, and the resulting vector (one for each cluster) will be
used as the input for metaclustering.
Defaults to \code{\link[stats]{median}}.}

\item{...}{Additional arguments to pass to the `tof_metacluster_*` function
family member corresponding to the chosen `method`.}

\item{augment}{A boolean value indicating if the output should column-bind the
metacluster ids of each cell as a new column in `tof_tibble` (TRUE; the default) or if
a single-column tibble including only the metacluster ids should be returned (FALSE).}

\item{method}{A string indicating which clustering method should be used. Valid
values include "consensus", "hierarchical", "kmeans", "phenograph", and "flowsom".}
}
\value{
A `tof_tbl` or `tibble` If augment = FALSE, it will have a single column encoding
the metacluster ids for each cell in `tof_tibble`. If augment = TRUE, it will have
ncol(tof_tibble) + 1 columns: each of the (unaltered) columns in `tof_tibble`
plus an additional column encoding the metacluster ids.
}
\description{
This function is a wrapper around tidytof's tof_metacluster_* function family.
It performs metaclustering on CyTOF data using a user-specified method (of 5 choices)
and each method's corresponding input parameters.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE)
    )

tof_metacluster(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    clustering_algorithm = "consensus",
    method = "flowsom"
)

tof_metacluster(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    method = "phenograph"
)

}
\seealso{
Other metaclustering functions: 
\code{\link{tof_metacluster_consensus}()},
\code{\link{tof_metacluster_flowsom}()},
\code{\link{tof_metacluster_hierarchical}()},
\code{\link{tof_metacluster_kmeans}()},
\code{\link{tof_metacluster_phenograph}()}
}
\concept{metaclustering functions}
