% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tof_make_knn_graph}
\alias{tof_make_knn_graph}
\title{Title}
\usage{
tof_make_knn_graph(
  tof_tibble,
  knn_cols,
  num_neighbors,
  distance_function = c("euclidean", "cosine"),
  graph_type = c("weighted", "unweighted"),
  ...
)
}
\arguments{
\item{tof_tibble}{A tibble or tof_tbl.}

\item{knn_cols}{Unquoted column names indicating which columns in tof_tibble
should be used for the KNN calculation.}

\item{num_neighbors}{An integer number of neighbors to find for each cell (
not including itself).}

\item{distance_function}{A string indicating which distance function to use
for the nearest-neighbor calculation. Options include "euclidean"
(the default) and "cosine" distances.}

\item{graph_type}{A string indicating if the graph's edges should have weights
("weighted"; the default) or not ("unweighted").}

\item{...}{Optional additional arguments to pass to \code{\link[tidytof]{tof_find_knn}}}
}
\value{
A \code{\link[tidygraph]{tbl_graph}}.
}
\description{
Title
}
\examples{
NULL

}
