% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling_helpers.R
\name{tof_log_rank_test}
\alias{tof_log_rank_test}
\title{Compute the log-rank test p-value for the difference between the two survival
curves obtained by splitting a dataset into a "low" and "high" risk group
using a given relative-risk threshold.}
\usage{
tof_log_rank_test(
  input_data,
  relative_risk_col,
  time_col,
  event_col,
  threshold
)
}
\arguments{
\item{input_data}{A tbl_df or data.frame in which each observation is a row.}

\item{relative_risk_col}{An unquote column name indicating which column contains
the relative-risk estimates for each observation.}

\item{time_col}{An unquoted column name indicating which column contains the
true time-to-event information for each observation.}

\item{event_col}{An unquoted column name indicating which column contains the
outcome (event or censorship). Must be a binary column - all values should be
 either 0 or 1 (with 1 indicating the adverse event and 0 indicating
 censorship) or FALSE and TRUE (with TRUE indicating the
adverse event and FALSE indicating censorship).}

\item{threshold}{A numeric value indicating the relative-risk threshold that
should be used to split observations into low- and high-risk groups.}
}
\value{
A numeric value <1, the p-value of the log-rank test.
}
\description{
Compute the log-rank test p-value for the difference between the two survival
curves obtained by splitting a dataset into a "low" and "high" risk group
using a given relative-risk threshold.
}
\examples{
NULL

}
