% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tof_tbl.R
\name{tof_get_panel}
\alias{tof_get_panel}
\title{Get panel information from a tof_tibble}
\usage{
tof_get_panel(tof_tibble)
}
\arguments{
\item{tof_tibble}{A `tof_tbl`.}
}
\value{
A tibble containing information about the CyTOF panel
that was used during data acquisition for the data contained
in `tof_tibble`.
}
\description{
Get panel information from a tof_tibble
}
\examples{
input_file <- dir(tidytof_example_data("aml"), full.names = TRUE)[[1]]
tof_tibble <- tof_read_data(input_file)
tof_get_panel(tof_tibble)

}
\seealso{
Other tof_tbl utilities: 
\code{\link{new_tof_tibble}()},
\code{\link{tof_set_panel}()}
}
\concept{tof_tbl utilities}
