% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling_helpers.R
\name{tof_fit_split}
\alias{tof_fit_split}
\title{Fit a glmnet model and calculate performance metrics using a single rsplit object}
\usage{
tof_fit_split(
  split_data,
  prepped_recipe,
  hyperparameter_grid,
  model_type,
  outcome_colnames
)
}
\arguments{
\item{split_data}{An `rsplit` object from the \code{\link[rsample]{rsample}}
package.
Alternatively, an unsplit tbl_df can be provided, though this is not recommended.}

\item{prepped_recipe}{A trained \code{\link[recipes]{recipe}}}

\item{hyperparameter_grid}{A tibble containing the hyperparameter values to tune.
Can be created using \code{\link{tof_create_grid}}}

\item{model_type}{A string representing the type of glmnet model being fit.}

\item{outcome_colnames}{Quoted column names indicating which columns in the data
being fit represent the outcome variables (with all others assumed to be predictors).}
}
\value{
A tibble with the same number of rows as the input hyperparameter grid.
Each row represents a combination of mixture and penalty, and each column contains
a performance metric for the fitted glmnet model on `split_data`'s holdout set.
The specific performance metrics depend on the type of model being fit:
\describe{
\item{"linear"}{mean-squared error (`mse`) and mean absolute error (`mae`)}
\item{"two-class"}{binomial deviance (`binomial_deviance`); misclassification error rate
`misclassification_error`; the area under the receiver-operating curve (`roc_auc`);
and `mse` and `mse` as above}
\item{"multiclass"}{multinomial deviance (`multinomial_deviance`); misclassification error rate
`misclassification_error`; the area under the receiver-operating curve (`roc_auc`)
computed using the Hand-Till method in \code{\link[yardstick]{roc_auc}};
and `mse` and `mse` as above}
\item{"survival"}{the negative log2-transformed partial likelihood (`neg_log_partial_likelihood`)
and Harrel's concordance index (often simply called "C"; `concordance_index`)}
}
}
\description{
This function trains a glmnet model on the training set of an rsplit object, then
calculates performance metrics of that model on the validation/holdout set
at all combinations of the mixture and
penalty hyperparameters provided in a hyperparameter grid.
}
\references{
Harrel Jr, F. E. and Lee, K. L. and Mark, D. B. (1996) Tutorial in biostatistics: multivariable prognostic models: issues in developing models, evaluating assumptions and adequacy, and measuring and reducing error, Statistics in Medicine, 15, pages 361–387.
}
