% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling_helpers.R
\name{tof_find_log_rank_threshold}
\alias{tof_find_log_rank_threshold}
\title{Compute the log-rank test p-value for the difference between the two survival
curves obtained by splitting a dataset into a "low" and "high" risk group
using all possible relative-risk thresholds.}
\usage{
tof_find_log_rank_threshold(input_data, relative_risk_col, time_col, event_col)
}
\arguments{
\item{input_data}{A tbl_df or data.frame in which each observation is a row.}

\item{relative_risk_col}{An unquote column name indicating which column contains
the relative-risk estimates for each observation.}

\item{time_col}{An unquoted column name indicating which column contains the
true time-to-event information for each observation.}

\item{event_col}{An unquoted column name indicating which column contains the
outcome (event or censorship). Must be a binary column - all values should be
 either 0 or 1 (with 1 indicating the adverse event and 0 indicating
 censorship) or FALSE and TRUE (with TRUE indicating the
adverse event and FALSE indicating censorship).}
}
\value{
A tibble with 3 columns: "candidate_thresholds" (the relative-risk threshold
used for the log-rank test), "log_rank_p_val" (the p-values of the log-rank
tests) and "is_best" (a logical value indicating which candidate threshold gave
the optimal, i.e. smallest, p-value).
}
\description{
Compute the log-rank test p-value for the difference between the two survival
curves obtained by splitting a dataset into a "low" and "high" risk group
using all possible relative-risk thresholds.
}
